/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.ComTaskResidual;
import com.bcxin.platform.dto.wallet.ComCheckTransferDTO;
import com.bcxin.platform.dto.wallet.ComWalletTradeDTO;
import com.bcxin.platform.dto.wallet.ComWalletTransferDTO;
import com.bcxin.platform.mapper.common.ComTaskResidualAPIMapper;
import com.bcxin.platform.service.common.ComTaskResidualAPIService;
import com.bcxin.platform.util.task.SpringContextHolder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="comTaskResidualAPIService")
@Transactional
public class ComTaskResidualAPIServiceImpl
implements ComTaskResidualAPIService {
    @Autowired
    private ComTaskResidualAPIMapper dao;
    @Resource
    private IdWorker idWorker;
    private Logger log = LoggerFactory.getLogger(ComTaskResidualAPIServiceImpl.class);

    @Override
    public void disposeComTaskResidualList(String is_nightly_run) {
        ComTaskResidual ct = new ComTaskResidual();
        if (StringUtils.isNotEmpty((CharSequence)is_nightly_run)) {
            ct.setIs_nightly_run(is_nightly_run);
        }
        List<ComTaskResidual> ctrList = this.dao.selectComTaskResidualByIsNightlyRun(ct);
        for (ComTaskResidual ctr : ctrList) {
            try {
                Thread.sleep(300L);
                new Thread(() -> this.applyReturnBooleanOfClassReflect(ctr)).start();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ComTaskResidual selectById(Long com_task_residual_id) {
        return this.dao.selectById(com_task_residual_id);
    }

    @Override
    public void applyReturnBooleanOfClassReflect(ComTaskResidual ctr) {
        System.err.println("----------ComTaskResidual\u672a\u6210\u529f\u4efb\u52a1\u53cd\u5c04\u6267\u884c\uff08" + ctr.getAnnotation() + ctr.getCom_task_residual_id() + "\uff09,\u5f00\u59cb");
        ClassLoader cls = Thread.currentThread().getContextClassLoader();
        String errEsg = "\u65e0\u5f02\u5e38-------------------------";
        try {
            Class<?> c = cls.loadClass(ctr.getClass_name());
            String[] tArr = ctr.getParam_type_arr().split(",");
            String[] vArr = ctr.getParam_value_arr().split(",");
            Class[] csArr = new Class[ctr.getParam_num()];
            Object[] otArr = new Object[ctr.getParam_num()];
            for (int i = 0; i < ctr.getParam_num(); ++i) {
                String tp = tArr[i];
                if ("String".equals(tp)) {
                    csArr[i] = String.class;
                    otArr[i] = String.valueOf(vArr[i]);
                    continue;
                }
                if ("int".equals(tp)) {
                    csArr[i] = Integer.TYPE;
                    otArr[i] = Integer.parseInt(vArr[i]);
                    continue;
                }
                if ("BigDecimal".equals(tp)) {
                    csArr[i] = BigDecimal.class;
                    otArr[i] = new BigDecimal(vArr[i]);
                    continue;
                }
                if ("Long".equals(tp)) {
                    csArr[i] = Long.class;
                    otArr[i] = Long.parseLong(vArr[i]);
                    continue;
                }
                if (tp.contains("ComWalletTransferDTO")) {
                    csArr[i] = ComWalletTransferDTO.class;
                    otArr[i] = JSONObject.parseObject((String)ctr.getParam_value_arr(), Class.forName(ctr.getParam_type_arr()));
                    continue;
                }
                if (tp.contains("ComCheckTransferDTO")) {
                    csArr[i] = ComCheckTransferDTO.class;
                    otArr[i] = JSONObject.parseObject((String)ctr.getParam_value_arr(), Class.forName(ctr.getParam_type_arr()));
                    continue;
                }
                if (tp.contains("ComWalletTradeDTO")) {
                    csArr[i] = ComWalletTradeDTO.class;
                    otArr[i] = JSONObject.parseObject((String)ctr.getParam_value_arr(), Class.forName(ctr.getParam_type_arr()));
                    continue;
                }
                csArr[i] = Object.class;
                otArr[i] = JSONObject.parseObject((String)ctr.getParam_value_arr(), Class.forName(ctr.getParam_type_arr()));
            }
            Object o = SpringContextHolder.getBean(c);
            Method method = o.getClass().getDeclaredMethod(ctr.getMethod_name(), csArr);
            method.setAccessible(true);
            Object r = method.invoke(o, otArr);
            boolean ret = false;
            if (r != null) {
                String str = JSON.toJSONString((Object)r);
                System.err.println("----------ComTaskResidual\u672a\u6210\u529f\u4efb\u52a1\u53cd\u5c04\u6267\u884c\uff08" + ctr.getAnnotation() + "\uff09,\u7ed3\u679c\uff1a" + str);
                Result result = (Result)JSON.parseObject((String)str, Result.class);
                if (result != null && "0".equals(result.getRetType())) {
                    ret = true;
                } else {
                    throw new SecurityException(str);
                }
            }
            if (ret) {
                this.dao.delete(ctr.getCom_task_residual_id());
            } else {
                errEsg = "Apply Method Fail!!--------------------------";
            }
        }
        catch (ClassNotFoundException e) {
            errEsg = e.getMessage();
        }
        catch (IllegalAccessException e) {
            errEsg = e.getMessage();
        }
        catch (NoSuchMethodException e) {
            errEsg = e.getMessage();
        }
        catch (SecurityException e) {
            errEsg = e.getMessage();
        }
        catch (IllegalArgumentException e) {
            errEsg = e.getMessage();
        }
        catch (InvocationTargetException e) {
            errEsg = e.getMessage();
        }
        System.err.println("----------ComTaskResidual\u672a\u6210\u529f\u4efb\u52a1\u53cd\u5c04\u6267\u884c\uff08" + ctr.getAnnotation() + "\uff09,ExceptionMessage\uff1a" + errEsg);
        this.log.info("----------ComTaskResidual\u672a\u6210\u529f\u4efb\u52a1\u53cd\u5c04\u6267\u884c\uff08" + ctr.getAnnotation() + "\uff09,ExceptionMessage\uff1a" + errEsg);
    }

    @Override
    public void saveComTaskResidual(String method_name, String annotation, String class_name, int param_num, String param_type_arr, String param_value_arr) {
        ComTaskResidual ctr = new ComTaskResidual(this.idWorker.nextId(), method_name, annotation, class_name, param_num, param_type_arr, param_value_arr, "0");
        new Thread(() -> {
            try {
                this.dao.insert(ctr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    @Override
    public void saveComTaskResidual2(String method_name, String annotation, String class_name, int param_num, String param_type_arr, String param_value_arr) {
        ComTaskResidual ctr = new ComTaskResidual(this.idWorker.nextId(), method_name, annotation, class_name, param_num, param_type_arr, param_value_arr, "1");
        new Thread(() -> {
            try {
                this.dao.insert(ctr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    public static void main(String[] args) {
        ComTaskResidualAPIServiceImpl c = new ComTaskResidualAPIServiceImpl();
        ComTaskResidual ctr = c.selectById(1026392461119287297L);
        c.applyReturnBooleanOfClassReflect(ctr);
    }
}

