package com.bcxin.identify.util.file.obs;

import com.bcxin.identify.util.codes.CommonConst;
import com.bcxin.identify.util.sys.ConfigUtil;
import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import com.obs.services.exception.ObsException;
import com.obs.services.model.HttpProtocolTypeEnum;
import com.obs.services.model.PutObjectResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;


public class OBSUtil {
    private static final Logger logger = LoggerFactory.getLogger(OBSUtil.class);
    private static final String END_POINT = "https://obs.cn-north-1.myhuaweicloud.com";
    private static final String CDN_POINT = "https://bcxinsaasprod.baibaodun.cn";

    private static final String AK = "YYSIHHGD8VTNTQVA2NCB";

    private static final String SK = "fd3My9hE8N7Byl4SJ8Mx0kKcn7gvaZoh506WGC0y";

    private static final String ENVI_PROD = "ENVI_PROD";

    private static ObsClient obsClient;
    private static String _BUCKET_NAME_PROD_VALUE;
    static {
        /* 初始化obs客户端*/
        //ObsConfiguration config = new ObsConfiguration();
        //config.setSocketTimeout(30000);
        //config.setConnectionTimeout(10000);
        // config.setEndPoint(END_POINT);
        //config.setReadBufferSize(8192);//设置初始缓冲区大小
        obsClient = createObsClient();//new ObsClient(AK, SK, config);
        _BUCKET_NAME_PROD_VALUE = ConfigUtil.getValue(CommonConst.HUAWEI_OSS_BUCKETNAME_PROD);
    }

    public static ObsClient createObsClient() {
        ObsConfiguration config = new ObsConfiguration();
        config.setHttpProtocolType(HttpProtocolTypeEnum.HTTP2_0);

        config.setEndPoint(END_POINT);
        return new ObsClient(
                AK,
                SK,
                config
        );
    }
    
    private String bucketName;

    public OBSUtil(String envi) {
        if (Objects.equals(envi, ENVI_PROD)) {
            bucketName = ConfigUtil.getValue(CommonConst.HUAWEI_OSS_BUCKETNAME_PROD);
        } else {
            bucketName = ConfigUtil.getValue(CommonConst.HUAWEI_OSS_BUCKETNAME_TEST);
        }
    }

    public String put(String folder, String ossKey, InputStream inputStream) throws IOException {
        try {
            PutObjectResult response = obsClient.putObject(bucketName, ossKey, inputStream);
            String url = response.getObjectUrl();
            //如果是生产的替换成cdn地址头
            if (StringUtils.isNotEmpty(url) && url.contains(_BUCKET_NAME_PROD_VALUE)) {
                url = CDN_POINT + url.split("myhuaweicloud.com")[1];
            }
            return url;
        } catch (ObsException e) {
            logger.error("Response Code: {}, Error Message: {}, Error Code: {}, Request ID:{}, Host ID:{}",
                    e.getResponseCode(),
                    e.getErrorMessage(), e.getErrorCode(), e.getErrorRequestId(), e.getErrorHostId(), e);
        }

        return null;
    }
}
