package com.bcxin.identify.util.codes;

/**
 * 公用常量编码
 */
public final class CommonConst {

	public final static String BLOB = "blob";

	public final static String MP3 = "mp3";

	public final static String AUTHENTICATION_ = "AUTHENTICATION_"; // 百保盾人脸识别认证标识

	/**
	 * 未删除
	 */
	public final static String NODELETE = "0"; // 未删除

	/**
	 * 已删除
	 */
	public final static String DELETE = "1"; // 已删除

	public final static String RETTYPE_SUCCESS = "0"; // 返回成功

	public final static String RETTYPE_FAIL = "-1"; // 返回失败

	public final static String DATE_CODE_YM = "yyyyMM"; // 日期编码

	public final static String DATE_CODE_YMD = "yyyy-MM-dd"; // 日期编码

	public final static String DATE_CODE_LONG = "yyyy-MM-dd HH:mm:ss"; // 日期编码

	public final static String ENCODE_UTF8_TEXT = "text/html; charset=UTF-8"; // 字符集编码UTF-8

	public final static String XLS = "xls"; // excel 1997-2003格式

	public final static String XLSX = "xlsx"; // excel 2003-2011格式

	public final static String SEPARATOR = "\\."; // 分隔符 分割文件名

	public final static String SLASH = "/"; // 斜杠

	public final static String EQUAL = "="; // 等号

	public final static String AND = "&"; // 与

	public final static String VIRGULE = "|"; // 竖线

	public final static String COLON_CN = "："; // 中文冒号

	public final static String COLON = ":"; // 冒号

	public final static String SEMICOLON = ";"; // 分号

	public final static String MINUS = "-"; // 减号

	public final static String DOT = "."; // 点

	public final static String COMMA = ","; // 逗号

	public final static String SIGN = "#"; // #

	public final static String COLON_SLASH = "://"; // 斜杠冒号

	public final static String DOLLAR = "$"; // 美元符号

	public final static String NULLSTRING = "<br/>"; // 空行

	public final static String BLANK_CHAR = ""; // 空字符串

	public final static String CONNECT_CHAR = "_"; // 空字符串

	public final static int LOOSE_PAGE_NUMBER = 10; // 宽松页码

	public final static int COMPACT_PAGE_NUMBER = 20; // 紧凑页码

	public final static String HTTP_OK = "200";

	public final static String HTTP_FAIL = "300";

	public final static String IMAGE_FORM = "jpg|jpeg|gif|png|bmp|JPG|JPEG|GIF|PNG|BMP"; // 图片格式

	public final static String ENVI_PROD = "ENVI_PROD"; // 平台标识
	public final static String SYS_PIC_PATH = "SYS_PIC_PATH"; // 系统全局图片操作系统保存的路径

	/************ 通用边界值（int）,用于数字类字段参数初始化引用 ************/
	public final static int BOUNDARY_INT_ZERO = 0; // 通用值0
	public final static int BOUNDARY_INT_ONE = 1; // 通用值1
	public final static int BOUNDARY_INT_TWO = 2; // 通用值2

	/******* POST 请求超时时间 ********/
	public static final String POS_TIME_OUT = "POS_TIME_OUT";
	/*************** 腾讯云相关配置 ****************/
	// 腾讯云SECRETID
	public static final String TENCENT_SECRETID = "TENCENT_SECRETID";
	// 腾讯云SECRETKEY
	public static final String TENCENT_SECRETKEY = "TENCENT_SECRETKEY";
	// 腾讯云SDKAPPID
	public static final String TENCENT_SDKAPPID = "TENCENT_SDKAPPID";
	// 腾讯云动态库的地址
	public static final String TENCENT_LIBPATH = "TENCENT_LIBPATH";
	// 腾讯云私钥地址
	public static final String TENCENT_EC_KEY = "TENCENT_EC_KEY";
	// 腾讯云公钥地址
	public static final String TENCENT_PUBLIC_KEY = "TENCENT_PUBLIC_KEY";
	// 腾讯云接口服务器地址
	public static final String TENCENT_IM_URL = "TENCENT_IM_URL";
	// 腾讯云管理员账号
	public static final String TENCENT_ADMIN = "TENCENT_ADMIN";
	/*************** 百度相关配置 ****************/
	// 百度人像比对地址
	public static final String BAIDU_FACE_MATCH_URL = "BAIDU_FACE_MATCH_URL";
	// 百度人像比对账号
	public static final String BAIDU_FACE_ACCOUNT = "BAIDU_FACE_ACCOUNT";
	// 百度身份证识别应用KEY
	public static final String BAIDU_ORC_ACCOUNT = "BAIDU_ORC_ACCOUNT";
	// 百度头像前景抠图应用KEY
	public static final String BAIDU_KT_ACCOUNT = "BAIDU_KT_ACCOUNT";
	// 百度登录accessToken
	public static final String BAIDU_ACCESS_TOKEN = "BAIDU_ACCESS_TOKEN";
	// 百度客户端凭证标识
	public static final String BAIDU_GRANT_TYPE = "BAIDU_GRANT_TYPE";
	// 百度身份证正反面比对地址
	public static final String BAIDU_IDCARD_AI_URL = "BAIDU_IDCARD_AI_URL";
	// 获取头像照片信息
	public static final String BAIDU_GET_PHOTO_IMAGE_INFO = "BAIDU_GET_PHOTO_IMAGE_INFO";
	// 生成分割后的人像前景抠图
	public static final String BAIDU_GET_HAED_IMAGE_EFFECT = "BAIDU_GET_HAED_IMAGE_EFFECT";
	// 华为obs
	public static final String HUAWEI_OSS_SERVERADDRESSS = "HUAWEI_OSS_SERVERADDRESSS";
	// 华为obs
	public static final String HUAWEI_OSS_SERVERADDRESSS_INTRANET = "HUAWEI_OSS_SERVERADDRESSS_INTRANET";
	// 华为obs
	public static final String HUAWEI_OSS_ACCESSID = "HUAWEI_OSS_ACCESSID";
	// 华为obs
	public static final String HUAWEI_OSS_ACCESSKEY = "HUAWEI_OSS_ACCESSKEY";
	// 华为obs
	public static final String HUAWEI_OSS_BUCKETNAME_TEST = "HUAWEI_OSS_BUCKETNAME_TEST";
	// 华为obs
	public static final String HUAWEI_OSS_BUCKETNAME_PROD = "HUAWEI_OSS_BUCKETNAME_PROD";
	/*************** 个推相关配置 ****************/
	public static final String GETUI_APP_ID = "GETUI_APP_ID";
	public static final String GETUI_APP_KEY = "GETUI_APP_KEY";
	public static final String GETUI_APP_SECRET = "GETUI_APP_SECRET";
	public static final String GETUI_MASTER_SECRET = "GETUI_MASTER_SECRET";

	/**
	 * 【模式一】账号初始化-身份证头像与活体照片比对
	 */
	public static final String FACE_BIZ_MODE_INITACCOUNT = "INITACCOUNT";
	/**
	 * 【模式二】培训过程人身核验
	 */
	public static final String FACE_BIZ_MODE_FACEAUTH = "FACEAUTH";
	/**
	 * 【模式三】头像比对 关闭活体 uniapp
	 */
	public static final String FACE_BIZ_MODE_UNIAPP = "UNIAPP";
	/**
	 * 【模式四】头像比对 高活体校验 HIGHLIVENESS
	 */
	public static final String FACE_BIZ_MODE_HIGHLIVENESS = "HIGHLIVENESS";

	public final static String PLATFORM = "IDENTIFY"; // 平台名称
	public final static String MSS_URL = "MSS_URL"; //
	public final static String TRAJ_EMAIL_WARN = "TRAJ_EMAIL_WARN"; //预警管理员邮箱
	public final static String WEB_URL = "WEB_URL"; //本系统域名地址头
}