package com.bcxin.identify.util.cache;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class RedisUtil {

    @Autowired
    protected RedisTemplate<String, String> redisTemplate;

    /**
     * 设置redisTemplate
     */
    public void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    /**
     * 获取 RedisSerializer
     */
    protected RedisSerializer<String> getRedisSerializer() {
        return redisTemplate.getStringSerializer();
    }

    /**
     * 保存
     * @param key
     * @param value
     * @return
     */
    public boolean set(String key, String value) {
        boolean result = redisTemplate.execute(new RedisCallback<Boolean>() {
            @Override
            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] k  = serializer.serialize(key);
                byte[] v = serializer.serialize(value);
                return connection.setNX(k, v);
            }
        });
        return result;
    }

    /**
     * 保存带过期时间
     * @param key
     * @param value
     * @param timeout（seconds）
     * @return
     */
    public boolean set(String key, String value, int timeout) {
        boolean result = redisTemplate.execute(new RedisCallback<Boolean>() {
            @Override
            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] k  = serializer.serialize(key);
                byte[] v = serializer.serialize(value);
                boolean r = connection.setNX(k, v);
                connection.expire(k, timeout);
                return r;
            }
        });
        return result;
    }

    /**
     * 根据指定key获取值
     * @param key
     * @return
     */
    public String get(String key) {
        String result = redisTemplate.execute(new RedisCallback<String>() {
            @Override
            public String doInRedis(RedisConnection connection)
                    throws DataAccessException {
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] k = serializer.serialize(key);
                byte[] v = connection.get(k);
                if (v == null) {
                    return null;
                }
                return serializer.deserialize(v);
            }
        });
        return result;
    }

    /**
     * 删除单个Key
     */
    public void delete(String key) {
        redisTemplate.delete(key);
    }


}
