package com.bcxin.identify.caches;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

/**
 * <b>  </b>
 * @author ZXF
 * @create 2025/09/09 0009 16:07
 * @version
 * @注意事项 </b>
 */
@Configuration
public class JedisClient {
    private int minIdle = 1;
    private int maxIdle = 8;
    private int maxTotal = 256;
    private int maxWait = 50;

    @Bean
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMinIdle(minIdle);
        jedisPoolConfig.setMaxIdle(maxIdle);
        jedisPoolConfig.setMaxTotal(maxTotal);
        jedisPoolConfig.setTestOnBorrow(true);
        jedisPoolConfig.setTestOnReturn(true);
        jedisPoolConfig.setBlockWhenExhausted(true);
        jedisPoolConfig.setMaxWaitMillis(maxWait);
        jedisPoolConfig.setFairness(false);
        return jedisPoolConfig;
    }

    @Bean
    public JedisPool jedisPool(@Value("${spring.redis.host}") String host,
                               @Value("${spring.redis.port}") int port,
                               @Value("${spring.redis.password}") String password,
                               @Value("${spring.redis.timeout:2000}") int timeout,
                               @Value("${spring.redis.database:0}") int database,
                               JedisPoolConfig jedisPoolConfig) {
        JedisPool pool=  new JedisPool(jedisPoolConfig, host, port, timeout, password, database);
        pool.getResource().ping();
        return pool;
    }
}
