package com.bcxin.identify.business.service;

import com.bcxin.identify.business.dao.AppVersionMapper;
import com.bcxin.identify.business.domain.AppVersion;
import com.bcxin.identify.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.Map;


@Service
@Transactional
@Slf4j
public class AppVersionService {
	
	@Autowired
	private AppVersionMapper appVersionMapper;
	
	
	/************ 查询，修改，保存相关 *********************/
	
	public AppVersion get(Long oid){
		return appVersionMapper.selectById(oid);
	}

	public Result getResult(Map<String,String> params){
		return Result.success("操作成功",get(Long.parseLong(params.get("oid"))));
	}


	public Result update(Map<String,String> params) throws Exception {
		AppVersion av = get(Long.parseLong(params.get("oid")));
		if(av == null){
			return Result.fail("无配置信息");
		}
		av.setAndroidVerName(params.get("androidVerName"));
		av.setVersion(params.get("version"));
		av.setApkSize(params.get("apkSize"));
		av.setApkWebURL(params.get("apkWebURL"));
		av.setAppWgtURL(params.get("appWgtURL"));
		av.setIOSLinkURL(params.get("iOSLinkURL"));
		av.setIOSVerName(params.get("iOSVerName"));
		av.setIsWgt(params.get("isWgt"));
		av.setUpdateOn(new Date());
		appVersionMapper.updateById(av);
		return Result.success("配置更新成功");
	}

	
}
