package com.bcxin.identify.api.common.controller;

import cn.hutool.core.util.StrUtil;
import com.bcxin.identify.business.service.AppVersionService;
import com.bcxin.identify.util.Result;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * <b> App配置信息业务 </b>
 * @author ZXF
 * @create 2021/01/28 0028 13:20
 * @version
 * @注意事项 </b>
 */
@Controller
@RequestMapping("/identify/api/common")
@Slf4j
public class AppVersionController {

    @Resource
    private AppVersionService appVersionService;

    @PostMapping(value = "/update-version")
    @ResponseBody
    public Result updateVersion(HttpServletRequest request) throws Exception {
        String oid = request.getParameter("oid");
        String androidVerName = request.getParameter("androidVerName");
        String version = request.getParameter("version");
        String iOSVerName = request.getParameter("iOSVerName");
        String apkSize = request.getParameter("apkSize");
        String isWgt = request.getParameter("isWgt");
        String appWgtURL = request.getParameter("appWgtURL");
        String apkWebURL = request.getParameter("apkWebURL");
        String iOSLinkURL = request.getParameter("iOSLinkURL");
        String token = request.getParameter("token");
        if(!"f4ghdfhr5hhwe3wcfv7bft9tj".equals(token)){
            return Result.fail("鉴权失败");
        }
//        log.debug("接口【/identify/api/common/update-version】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("oid",oid);
        params.put("version",version == null?"":version);
        params.put("androidVerName",androidVerName == null?"":androidVerName);
        params.put("iOSVerName",iOSVerName == null?"":iOSVerName);
        params.put("apkSize",apkSize == null?"":apkSize);
        params.put("isWgt",isWgt == null?"":isWgt);
        params.put("appWgtURL",appWgtURL == null?"":appWgtURL);
        params.put("apkWebURL",apkWebURL == null?"":apkWebURL);
        params.put("iOSLinkURL",iOSLinkURL == null?"":iOSLinkURL);

        if (StrUtil.isEmpty(params.get("oid"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/common/update-version】App更新接口信息流程开始。");
        Result result = appVersionService.update(params);
        log.debug("接口【/identify/api/common/update-version】App更新接口信息流程结束。");
        return result;
    }

    @RequestMapping(value = "/get-version")
    @ResponseBody
    public Result getVersion(HttpServletRequest request) throws Exception {
        String oid = request.getParameter("oid");
//        String token = request.getParameter("token");
//        log.debug("接口【/identify/api/common/get-version】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("oid",oid);

        if (StrUtil.isEmpty(params.get("oid"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/common/get-version】获取App配置信息流程开始。");
        Result result = appVersionService.getResult(params);
        log.debug("接口【/identify/api/common/get-version】获取App配置信息流程结束。");
        return result;
    }

}
