package com.bcxin.message.service.tenant;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.message.dao.mapper.tenant.TenantEmployeesMapper;
import com.bcxin.message.entity.tenant.TenantEmployeesEntity;
import com.bcxin.message.service.RedisCache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * description：智能人事-职员表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class TenantEmployeesService extends ServiceImpl<TenantEmployeesMapper, TenantEmployeesEntity> {

    @Autowired
    private RedisCache redisCache;

    /**
     * description：根据用户id，获取组织id列表
     * author：linchunpeng
     * date：2025/8/11
     */
    public List<String> getOrgIdListByUserId(String userId) {
        String key = "message-center:orgId-list:userId:" + userId;
        List<String> value = redisCache.getCacheObject(key);
        if (value != null) {
            return value;
        }
        value = new ArrayList<>();
        LambdaQueryChainWrapper<TenantEmployeesEntity> lqw = this.lambdaQuery();
        lqw.eq(TenantEmployeesEntity::getTenantUserId, userId);
        lqw.eq(TenantEmployeesEntity::getStatus, 0);
        List<TenantEmployeesEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            value = list.stream().map(TenantEmployeesEntity::getOrganizationId).collect(Collectors.toList());
        }
        redisCache.setCacheObject(key, value, 1, TimeUnit.HOURS);
        return value;
    }

}