package com.bcxin.message.service.messagecenter;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.message.common.utils.IdGeneratorSnowflake;
import com.bcxin.message.dao.mapper.messagecenter.MsgRequestLogMapper;
import com.bcxin.message.entity.messagecenter.MsgRequestLogEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * description：消息中心请求日志表 service
 * author：linchunpeng
 * date：2023/11/17
 */
@Slf4j
@Service
public class MsgRequestLogService extends ServiceImpl<MsgRequestLogMapper, MsgRequestLogEntity> {

    @Autowired
    private IdGeneratorSnowflake snowflake;

    /**
     * description：创建请求日志
     * author：linchunpeng
     * date：2023/11/17
     */
    @Transactional
    public void createLog(String requestId, String appid, String requestUrl, String requestParam) {
        MsgRequestLogEntity msgRequestLogEntity = new MsgRequestLogEntity();
        msgRequestLogEntity.setId(snowflake.snowflakeId());
        msgRequestLogEntity.setRequestId(requestId);
        msgRequestLogEntity.setAppid(appid);
        msgRequestLogEntity.setRequestUrl(requestUrl);
        msgRequestLogEntity.setRequestParam(requestParam);
        msgRequestLogEntity.setCreateTime(new Date());
        msgRequestLogEntity.setUpdateTime(new Date());
        this.save(msgRequestLogEntity);
    }

    /**
     * description：更新请求结果
     * author：linchunpeng
     * date：2023/11/17
     */
    @Transactional
    public void updateRequestResult(String requestId, String requestResult) {
        this.lambdaUpdate()
                .eq(MsgRequestLogEntity::getRequestId, requestId)
                .set(MsgRequestLogEntity::getRequestResult, requestResult)
                .set(MsgRequestLogEntity::getUpdateTime, new Date())
                .update();
    }

}
