package com.bcxin.message.service.messagecenter;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.message.dao.mapper.messagecenter.MsgOrgEffectiveTimeMapper;
import com.bcxin.message.entity.messagecenter.MsgOrgEffectiveTimeEntity;
import com.bcxin.message.service.RedisCache;
import com.bcxin.message.service.tenant.ExternalMembersService;
import com.bcxin.message.service.tenant.TenantEmployeesService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * description：消息中心-消息组织有效期表 service
 * author：linchunpeng
 * date：2025/8/11
 */
@Slf4j
@Service
public class MsgOrgEffectiveTimeService extends ServiceImpl<MsgOrgEffectiveTimeMapper, MsgOrgEffectiveTimeEntity> {

    @Autowired
    private TenantEmployeesService tenantEmployeesService;
    @Autowired
    private ExternalMembersService externalMembersService;
    @Autowired
    private RedisCache redisCache;

    //默认消息过期时间，天数
    @Value("${message.default-effective-time}")
    private Integer defaultEffectiveTime;


    /**
     * description：通过用户id获取有效期天数
     * author：linchunpeng
     * date：2025/8/11
     */
    public String getOrgIdAndEffectiveTimeByUserId(String userId) {
        String key = "message-center:msg:effective-time:userId:" + userId;
        String value = redisCache.getCacheObject(key);
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        List<String> orgIdList = new ArrayList<>();
        orgIdList.addAll(tenantEmployeesService.getOrgIdListByUserId(userId));
        orgIdList.addAll(externalMembersService.getOrgIdListByUserId(userId));

        if (CollectionUtil.isNotEmpty(orgIdList)) {
            String keyOrg = "message-center:msg:effective-time:orgId:" + String.join(";", orgIdList);
            value = redisCache.getCacheObject(keyOrg);
            if (StringUtils.isNotBlank(value)) {
                return value;
            }
            int effectiveTime = 0;
            String orgId = "0";
            MsgOrgEffectiveTimeEntity msgOrgEffectiveTimeEntity = this.baseMapper.selectMaxEffectiveTimeByOrgIdList(orgIdList);
            if (msgOrgEffectiveTimeEntity == null) {
                effectiveTime = defaultEffectiveTime;
                orgId = orgIdList.get(0);
            } else {
                effectiveTime = msgOrgEffectiveTimeEntity.getEffectiveTime();
                orgId = msgOrgEffectiveTimeEntity.getOrganizationId();
            }
            value = orgId + ";" + effectiveTime;
            redisCache.setCacheObject(keyOrg, value, 1, TimeUnit.HOURS);
        }
        if (StringUtils.isBlank(value)) {
            value = "0;" + defaultEffectiveTime;
        }
        redisCache.setCacheObject(key, value, 1, TimeUnit.HOURS);
        return value;
    }

}
