package com.bcxin.message.service.messagecenter;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.message.common.utils.IdGeneratorSnowflake;
import com.bcxin.message.dao.mapper.messagecenter.MsgExceptionMapper;
import com.bcxin.message.entity.messagecenter.MsgExceptionEntity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * description：消息中心异常表 service
 * author：linchunpeng
 * date：2023/11/17
 */
@Slf4j
@Service
public class MsgExceptionService extends ServiceImpl<MsgExceptionMapper, MsgExceptionEntity> {

    @Autowired
    private IdGeneratorSnowflake snowflake;

    /**
     * description：创建异常记录
     * author：linchunpeng
     * date：2023/11/17
     */
    @Transactional
    public void createException(String requestId, String appid, String requestUrl, String requestParam, String exceptionInfo) {
        MsgExceptionEntity msgExceptionEntity = new MsgExceptionEntity();
        msgExceptionEntity.setId(snowflake.snowflakeId());
        msgExceptionEntity.setRequestId(requestId);
        msgExceptionEntity.setAppid(appid);
        msgExceptionEntity.setRequestUrl(requestUrl);
        msgExceptionEntity.setRequestParam(requestParam);
        if (StringUtils.isNotBlank(exceptionInfo) && exceptionInfo.length() > 5000) {
            exceptionInfo = exceptionInfo.substring(0, 4999);
        }
        msgExceptionEntity.setExceptionInfo(exceptionInfo);
        msgExceptionEntity.setCreateTime(new Date());
        msgExceptionEntity.setUpdateTime(new Date());
        this.save(msgExceptionEntity);
    }

}
