package com.bcxin.message.service.messagecenter;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.message.dao.mapper.messagecenter.MsgAdminUserMapper;
import com.bcxin.message.entity.messagecenter.MsgAdminUserEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * description：消息中心用户表 service
 * author：linchunpeng
 * date：2023/11/17
 */
@Slf4j
@Service
public class MsgAdminUserService extends ServiceImpl<MsgAdminUserMapper, MsgAdminUserEntity> {


    /**
     * description：通过appid查询消息中心用户表
     * author：linchunpeng
     * date：2023/11/17
     */
    public MsgAdminUserEntity findByAppid(String appid) {
        LambdaQueryChainWrapper<MsgAdminUserEntity> lqw = this.lambdaQuery();
        lqw.eq(MsgAdminUserEntity::getAppid, appid);
        return lqw.one();
    }

}
