package com.bcxin.message.scheduled.task;

import com.bcxin.message.entity.messagecenter.MsgSyncTimeTaskEntity;
import com.bcxin.message.service.messagecenter.MsgSyncTimeTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * description：同步消息时间任务
 * author：linchunpeng
 * date：2025/8/12
 */
@Slf4j
@Component
public class SyncMsgTimeTask {

    @Autowired
    private MsgSyncTimeTaskService msgSyncTimeTaskService;

    @Scheduled(cron = "${message.sync-msg-time-task.cron}")
    public void createMsgSyncTimeTask() {
        log.info("===================================同步消息时间任务===================================");
        MsgSyncTimeTaskEntity initTask = msgSyncTimeTaskService.getInitTask();
        if (initTask != null) {
            Map<String, String> syncResultMap = msgSyncTimeTaskService.syncMsgTime(initTask.getStartTime(), initTask.getEndTime());
            msgSyncTimeTaskService.setTaskComplete(initTask, syncResultMap);
        }
        log.info("===================================同步消息时间任务结束===================================");
    }

}
