package com.bcxin.message.scheduled.task;

import com.bcxin.message.service.messagecenter.MsgSyncTimeTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * description：创建消息同步时间任务
 * author：linchunpeng
 * date：2025/8/12
 */
@Slf4j
@Component
public class CreateMsgSyncTimeTask {

    @Autowired
    private MsgSyncTimeTaskService msgSyncTimeTaskService;

    @Scheduled(cron = "${message.create-msg-sync-time-task.cron}")
    public void createMsgSyncTimeTask() {
        log.info("===================================创建消息同步时间任务===================================");
        msgSyncTimeTaskService.createMsgSyncTimeTask();
        log.info("===================================创建消息同步时间任务结束===================================");
    }

}
