package com.bcxin.message.scheduled.message;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.message.dtos.request.SendRobotMessageRequest;
import com.bcxin.message.entity.messagecenter.MsgSendLogEntity;
import com.bcxin.message.service.messagecenter.MsgSendLogService;
import com.bcxin.message.service.YehuoService;
import lombok.extern.slf4j.Slf4j;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * description：发送重试任务
 * author：linchunpeng
 * date：2023/11/22
 */
@Component
@Slf4j
public class SendRetryJob implements Job {

    @Autowired
    private YehuoService yehuoService;
    @Autowired
    private MsgSendLogService msgSendLogService;

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        log.info("===========发送重试任务===========");
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        Long jobId = (Long) jobDataMap.get("jobId");
        if (jobId != null) {
            MsgSendLogEntity msgSendLogEntity = msgSendLogService.getById(jobId);
            if (msgSendLogEntity != null) {
                log.info("开始执行发送重试任务，requestId:{}", msgSendLogEntity.getRequestId());
                yehuoService.sendMessage(JSONObject.parseObject(msgSendLogEntity.getSendParam(), SendRobotMessageRequest.class));
            } else {
                log.info("消息中心发送日志为空，无法重试，id:{}", jobId);
            }
        }
    }
}
