package com.bcxin.message.entity.messagecenter;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * description：消息发送请求表
 * author：linchunpeng
 * date：2025/7/9
 */
@Data
@TableName("msg_send_request")
public class MsgSendRequestEntity {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //请求id
    private String requestId;

    //appid
    private String appid;

    //发送者
    private String sender;

    //目标类型，user用户，group群组
    private String targetType;

    //目标id，发给多个目标英文逗号隔开
    private String targetIds;

    //消息类型，text文本消息
    private String messageType;

    //消息内容，json格式
    private String messageContent;

    //状态：0-未发送，1-发送成功，2-发送失败
    private Integer status;

    //备注
    private String remark;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    //最后修改时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

}
