package com.bcxin.message.entity.messagecenter;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * description：消息中心发送日志表
 * author：linchunpeng
 * date：2023/11/17
 */
@Data
@TableName("msg_send_log")
public class MsgSendLogEntity {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //请求id
    private String requestId;

    //appid
    private String appid;

    //发送者
    private String sender;

    //发送者类型，robot机器人，channel频道
    private String senderType;

    //发送策略，用来获取策略实现
    private String sendStrategy;

    //发送参数
    private String sendParam;

    //是否发送成功，1是，0否
    private Integer sendSuccess;

    //发送结果
    private String sendResult;

    //发送重试次数
    private Integer sendRetryCount;

    //备注
    private String remark;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;

    //最后修改时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;

}
