package com.bcxin.message.entity.messagecenter;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * description：群组创建表
 * author：linchunpeng
 * date：2025/7/9
 */
@Data
@TableName("msg_group_create")
public class MsgGroupCreateEntity {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //第三方id
    private String thirdId;

    //群信息，json格式
    private String groupInfo;

    //群成员，json格式
    private String members;

    //操作者用户ID，tenant_user_id
    private String operator;

    //状态：0-未创建，1-创建成功，2-创建失败
    private Integer status;

    //创建成功后的IM群组id
    private String groupId;

    //备注
    private String remark;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    //最后修改时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

}
