package com.bcxin.message.entity.messagecenter;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * description：消息中心-消息过期时间表
 * author：linchunpeng
 * date：2025/8/11
 */
@Data
@TableName("msg_expired_time")
public class MsgExpiredTimeEntity {

    private static final long serialVersionUID = 1L;

    //主键id/消息id
    @TableId(value = "id")
    private Long id;

    //表空间序号
    private Integer number;

    //组织id
    private String organizationId;

    //用户id
    private String userId;

    //发送时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date sendTime;

    //到期时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date expiredTime;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;

}
