package com.bcxin.message.entity.messagecenter;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * description：消息中心用户发送者表
 * author：linchunpeng
 * date：2023/11/17
 */
@Data
@TableName("msg_admin_user_sender")
public class MsgAdminUserSenderEntity {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //appid
    private String appid;

    //发送者（机器人或频道）
    private String sender;

    //发送者类型，robot机器人，channel频道
    private String senderType;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;

    //最后修改时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;

}
