package com.bcxin.message.entity.messagecenter;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * description：消息中心用户表
 * author：linchunpeng
 * date：2023/11/17
 */
@Data
@TableName("msg_admin_user")
public class MsgAdminUserEntity {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //appid
    private String appid;

    //secret
    private String secret;

    //名称
    private String name;

    //备注
    private String remark;

    //状态：0无效，1有效
    private Integer status;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;

    //最后修改时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;

}
