package com.bcxin.message.dtos.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

@Data
public class MsgSendLogResponse {

    //请求id
    private String requestId;

    //发送者
    private String sender;

    //发送者类型，robot机器人，channel频道
    private String senderType;

    //是否发送成功，1是，0否
    private Integer sendSuccess;

    //备注
    private String remark;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;

    //最后修改时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;
}

