package com.bcxin.message.dtos.request;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.bcxin.message.dtos.yehuo.MessageContent;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class SendRobotMessageRequest {

    @JsonIgnore
    private String appid;
    @JsonIgnore
    private String requestId;
    @JsonIgnore
    private String senderType;
    @JsonIgnore
    private Integer source;//发送消息来源，1：发送请求表，2：发送接口api

    /**
     * 发送者（机器人或频道）
     */
    @NotBlank(message = "发送者不能为空")
    private String sender;

    /**
     * 目标类型，user用户，group群组
     */
    @NotBlank(message = "目标类型不能为空")
    private String targetType;

    /**
     * 目标id列表
     */
    @NotEmpty(message = "目标id列表不能为空")
    private List<String> targetIds;
    /**
     * 消息类型，text文本消息
     */
    @NotBlank(message = "消息类型不能为空")
    private String messageType;
    /**
     * 消息内容
     */
    @NotBlank(message = "消息内容不能为空")
    private String messageContent;

    @JSONField(serialize = false)
    public MessageContent getMessageContentObject() {
        return JSONObject.parseObject(this.getMessageContent(), MessageContent.class);
    }
}

