package com.bcxin.message.dtos.kafka.record;

import lombok.Data;

/**
 * kafka记录
 */
@Data
public class MsgSendRequestKafkaRecord {
    private MsgSendRequestRecord before;
    private MsgSendRequestRecord after;

    @Data
    public static class MsgSendRequestRecord {
        //id
        private Long id;
        //请求id
        private String request_id;
        //appid
        private String appid;
        //发送者
        private String sender;
        //目标类型，user用户，group群组
        private String target_type;
        //目标id，发给多个目标英文逗号隔开
        private String target_ids;
        //消息类型，text文本消息
        private String message_type;
        //消息内容，json格式
        private String message_content;
        //状态：0-未发送，1-发送成功，2-发送失败
        private Integer status;
    }
}
