package com.bcxin.message.controller;


import com.bcxin.message.common.CommonConstant;
import com.bcxin.message.common.emus.StatusCode;
import com.bcxin.message.dtos.request.BindSenderRequest;
import com.bcxin.message.dtos.request.CreateChannelRequest;
import com.bcxin.message.dtos.request.CreateRobotRequest;
import com.bcxin.message.dtos.response.result.RespResult;
import com.bcxin.message.service.YehuoService;
import com.bcxin.message.service.messagecenter.MsgAdminUserSenderService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

@Slf4j
@RestController
@RequestMapping("/api/v1/manager")
public class YehuoManagerController {

    @Value("${api-auth.admin-secret}")
    private String adminSecret;

    @Autowired
    private YehuoService yehuoService;

    @Autowired
    private MsgAdminUserSenderService msgAdminUserSenderService;


    /**
     * description：创建机器人
     * author：linchunpeng
     * date：2023/11/21
     */
    @PostMapping("/create/robot")
    public RespResult<String> createRobot(@RequestBody @Valid CreateRobotRequest request, HttpServletRequest httpServletRequest) {
        String secret = httpServletRequest.getHeader(CommonConstant.MSG_REQUEST_HEADER_SECRET);
        if (adminSecret.equals(secret)) {
            yehuoService.createRobot(request);
            return RespResult.successful("创建机器人成功");
        }
        return RespResult.failure(StatusCode.unauthorized);
    }

    /**
     * description：创建频道
     * author：linchunpeng
     * date：2023/11/21
     */
    @PostMapping("/create/channel")
    public RespResult<String> createChannel(@RequestBody @Valid CreateChannelRequest request, HttpServletRequest httpServletRequest) {
        String secret = httpServletRequest.getHeader(CommonConstant.MSG_REQUEST_HEADER_SECRET);
        if (adminSecret.equals(secret)) {
            yehuoService.createChannel(request);
            return RespResult.successful("创建频道成功");
        }
        return RespResult.failure(StatusCode.unauthorized);
    }

    /**
     * description：appid绑定sender
     * author：linchunpeng
     * date：2023/11/21
     */
    @PostMapping("/bind/sender")
    public RespResult<String> bindSender(@RequestBody @Valid BindSenderRequest request, HttpServletRequest httpServletRequest) {
        String secret = httpServletRequest.getHeader(CommonConstant.MSG_REQUEST_HEADER_SECRET);
        if (adminSecret.equals(secret)) {
            msgAdminUserSenderService.bindSender(request);
            return RespResult.successful("绑定成功");
        }
        return RespResult.failure(StatusCode.unauthorized);
    }

}
