package com.bcxin.message.consumer;

import com.bcxin.message.common.CommonConstant;
import com.bcxin.message.common.emus.MsgGroupCreateStatus;
import com.bcxin.message.common.utils.KafkaMessageUtil;
import com.bcxin.message.dtos.kafka.message.MsgGroupCreateKafkaMessage;
import com.bcxin.message.service.messagecenter.MsgGroupCreateService;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

/**
 * 驻勤点kafka监听器
 */
@Slf4j
@Component
public class MsgGroupCreateKafkaConsumer {

    @Autowired
    private MsgGroupCreateService msgGroupCreateService;

    @KafkaListener(id = "bcx_message_center_listener_msg_group_create",
            topics = CommonConstant.MSG_GROUP_CREATE_KAFKA_TOPIC,
            groupId = "bcx_message_center_listener_msg_group_create")
    public void bcxMessageCenterListenerMsgGroupCreate(ConsumerRecord<String, String> record, Acknowledgment ack) {
        MsgGroupCreateKafkaMessage kafkaMessage = KafkaMessageUtil.transferKafkaMsgGroupCreateRecord2Message(record);
        log.info("kafka监听：messagecenter.msg_group_create表，id：{}", kafkaMessage.getId());
        try {
            if (kafkaMessage.getId() != null
                    && (kafkaMessage.getStatus() == null
                    || kafkaMessage.getStatus() == MsgGroupCreateStatus.NOT_CREATE.getCode())) {
                log.info("调用创建群组方法");
                msgGroupCreateService.createGroup(kafkaMessage);
            }
        } catch (Exception e) {
            log.error("kafka监听：messagecenter.msg_group_create表，异常：{}", e.getMessage(), e);
        }
        ack.acknowledge();
    }
}
