package com.bcxin.message.configs;

import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

@Configuration
public class DataSourceConfig {

    @Primary
    @Bean(name = "messagecenterDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.messagecenter")
    public DataSource messagecenterDataSource() {
        return new HikariDataSource();
    }

    @Bean(name = "tenantDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.tenant")
    public DataSource tenantDataSource() {
        return new HikariDataSource();
    }

    @Bean(name = "yehuoDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.yehuo")
    public DataSource yehuoDataSource() {
        return new HikariDataSource();
    }

    @Primary
    @Bean(name = "messagecenterTransactionManager")
    public DataSourceTransactionManager messagecenterTransactionManager(@Qualifier("messagecenterDataSource") DataSource messagecenterDataSource) {
        return new DataSourceTransactionManager(messagecenterDataSource);
    }

    @Bean(name = "tenantTransactionManager")
    public DataSourceTransactionManager tenantTransactionManager(@Qualifier("tenantDataSource") DataSource tenantDataSource) {
        return new DataSourceTransactionManager(tenantDataSource);
    }

    @Bean(name = "yehuoTransactionManager")
    public DataSourceTransactionManager yehuoTransactionManager(@Qualifier("yehuoDataSource") DataSource yehuoDataSource) {
        return new DataSourceTransactionManager(yehuoDataSource);
    }

    @Primary
    @Bean(name = "messagecenterSqlSessionFactory")
    public SqlSessionFactory messagecenterSqlSessionFactory(@Qualifier("messagecenterDataSource") DataSource messagecenterDataSource) throws Exception {
        MybatisSqlSessionFactoryBean sessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(messagecenterDataSource);
        sessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mybatis/messagecenter/*.xml"));
        return sessionFactoryBean.getObject();
    }

    @Bean(name = "tenantSqlSessionFactory")
    public SqlSessionFactory tenantSqlSessionFactory(@Qualifier("tenantDataSource") DataSource tenantDataSource) throws Exception {
        MybatisSqlSessionFactoryBean sessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(tenantDataSource);
        sessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mybatis/tenant/*.xml"));
        return sessionFactoryBean.getObject();
    }

    @Bean(name = "yehuoSqlSessionFactory")
    public SqlSessionFactory yehuoSqlSessionFactory(@Qualifier("yehuoDataSource") DataSource yehuoDataSource) throws Exception {
        MybatisSqlSessionFactoryBean sessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(yehuoDataSource);
        sessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mybatis/yehuo/*.xml"));
        return sessionFactoryBean.getObject();
    }

}
