package com.bcxin.rest.sys.company.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.common.constants.GlobalConstants;
import com.bcxin.common.dto.AjaxResult;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.entity.SysCompany;
import com.bcxin.core.entity.SysCompanyContacts;
import com.bcxin.core.entity.SysUser;
import com.bcxin.core.service.SysAreaRelationService;
import com.bcxin.core.service.SysCompanyContactsService;
import com.bcxin.core.service.SysCompanyService;
import com.bcxin.models.product.service.ProductRelationService;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.bcxin.spring.http.HttpService;
import com.bcxin.util.toolbox.StrUtil;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 机构同步(终端机构)
 * Created by playboy on 2017/5/25.
 */
@Controller
@RequestMapping("${apiPath}/webCompany")
public class SysCompanyApiController extends BaseController {

    @Autowired
    private SysCompanyService sysCompanyService;

    @Autowired
    private SysCompanyContactsService sysCompanyContactsService;

    @Autowired
    private ProductRelationService productRelationService;

    @Autowired
    private SysAreaRelationService sysAreaRelationService;

    /**
     * 终端机构同步
     * @return
     */
    @RequestMapping(value = "/receiveTerminalData",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult receiveTerminalCompany(SysCompany sysCompany){
        String msg = beanValidatorAPI(sysCompany);
        if(StrUtil.isNotBlank(msg)){
            return fail(false,msg);
        }

        if(sysCompany.getCompanyType() ==null){
            sysCompany.setCompanyType(SysCompany.TERMINAL_TYPE_BUSINESS);
        }
        sysCompanyService.save(sysCompany);
        List<SysCompanyContacts> list = sysCompany.getContactsList();
        if(null!=list&&list.size()>0){
            if(null!=sysCompany.getId()){
                sysCompanyContactsService.delete(new EntityWrapper().addFilter("company_id={0}",sysCompany.getId()));
                for (SysCompanyContacts sysCompanyContacts:list){
                    sysCompanyContacts.setSysCompany(sysCompany);
                    sysCompanyContactsService.insert(sysCompanyContacts);
                }
            }

        }
        return new AjaxResult(true,"操作成功", sysCompany.getId());
    }

    /**
     * 供应商查询接口
     * @param sign //平台标识
     * @param type //机构类型   1保险公司,2:培训供应,3:风评供应商
     * @return
     */
    @RequestMapping(value = "/querySupplierlData",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult querySupplierCompany(@RequestParam String sign, @RequestParam String type,String startDate){
        if(StrUtil.isBlank(type)){
            return fail(false,"类型不能为空");
        }
        SysCompany sysCompany = new SysCompany();
        sysCompany.setCompanyType(SysCompany.COMPANY_TYPE_SUPPLIER); //1为保险公司
        sysCompany.setEnterpriseType(type);
        sysCompany.setStartDate(startDate);
        sysCompany.setStatus(-1);
        List<SysCompany> companyList = sysCompanyService.getCompanyApiList(sysCompany);
        return  json(true,companyList);
    }
    /**
     * 分销商查询是否分销商 并返回ID
     * @param sign //平台标识
     * @param  webUserId //第三方平台ID
     * @return
     */
    @RequestMapping("/checkDistributorCompany")
    @ResponseBody
    public AjaxResult checkDistributorCompany(@RequestParam String sign, @RequestParam String webUserId){
        if(StrUtil.isBlank(webUserId)){
            return fail(false,"用户ID不能为空");
        }
        SysUser user = new SysUser();
        user.setWebUserId(webUserId);
        user.setWebType(sign);
        SysCompany company = sysCompanyService.getCompanyBySysUser(user);
        if(null!=company&&company.getId()!=null){
            //验证是否分销商
            if(company.getCompanyType().equals(SysCompany.COMPANY_TYPE_DISTRIBUTOR)) {
                return new AjaxResult(true, "该用户是分销商", company.getId());
            }
        }
        return  fail(false,"该用户不是分销商");
    }

    /**
     * 获取产品有权限的分销商列表
     */
    @RequestMapping("/queryDistributorCompanyList")
    @ResponseBody
    public AjaxResult queryDistributorCompanyList(@RequestParam String sign,@RequestParam  String productId){
        Map<String,Object> params = Maps.newHashMap();
        params.put("productId",productId);
        params.put("type","1");
        params.put("companyType","2");
        List<Map<String,Object>> companyMap = productRelationService.getCompanyDList(params);
        return  json(true, companyMap);
    }

    /**
     * 核心系统特有接口获取所有机构信息
     * @return
     */
    @RequestMapping("/getSysCompanyHXXT")
    @ResponseBody
    public AjaxResult getSysCompanyHXXT(Date startDate){
        Map<String,Object> params = Maps.newHashMap();
        params.put("startDate",startDate);
        params.put("inCompanyStr",new String[]{"1","2","4"});
        List<SysCompany> list = sysCompanyService.getCompanyListData(params);
        return new AjaxResult(true,list);
    }

   /**
     * 核心系统特有接口获取所有限制销售区域
     * @return
     */
    @RequestMapping("/getSysCompanyAreaHXXT")
    @ResponseBody
    public AjaxResult getSysCompanyAreaHXXT(Date startDate){
        Map<String,Object> params=Maps.newHashMap();
        params.put("startDate",startDate);
        List<Map<String,Object>> list = sysAreaRelationService.selectToHxxt(params);
        return new AjaxResult(true,StrUtil.formatDate(list));
    }
}
