package com.bcxin.rest.bill.web;

import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.entity.SysCompany;
import com.bcxin.core.entity.SysUser;
import com.bcxin.core.service.SysCompanyService;
import com.bcxin.models.fee.entity.FeeSettlement;
import com.bcxin.models.fee.service.FeeSettlementService;
import com.bcxin.models.order.dao.OrderFormDao;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 下级分销商账单
 * @author lyq
 */
@Controller
@RequestMapping("${apiPath}/bill/sub")
public class BillSubController extends BaseController {

    //分销商下级账单列表
    private static final String SUBDISTRIBUTOR_LIST = getViewPath("admin/fee/company/api/subdistributor_list");

    //分销商下级列表详细信息
    private static final String DISTRIBUTOR_DETATIL = getViewPath("admin/fee/company/api/next/distributor_detatil");


    @Autowired
    private OrderFormDao orderFormDao;

    @Autowired
    private SysCompanyService  companyService;

    @Autowired
    private FeeSettlementService feeSettlementService;


    /**
     *  下级账单
     * @param request
     * @param model
     * @return
     */
    @RequestMapping("/initDistributorListByID")
    public String InitDistributorList(HttpServletRequest request,Model model){
        String   uid=request.getParameter("uid");
        if (StringUtils.isEmpty(uid)){
            logger.info("uid 为空");
            return "redirect:/api/bill/noFind";
        }
        String distributorId= orderFormDao.findCompanyIDByID(uid);
        if (distributorId==null||"null".equals(distributorId)||"".equals(distributorId)){
            logger.info("订单未找到归属的分销商");
            return "redirect:/api/bill/noFind";
        }
        //查找该分销商账号
        SysCompany  company=companyService.get(Long.parseLong(distributorId));
        if(company==null){
            return "redirect:/api/bill/noFind";
        }
        SysUser user = new SysUser();
        user.setLoginName("培训账号");
        request.getSession().setAttribute("company",company);
        Map<String,String> map =feeSettlementService.getTotalFee(SysCompany.COMPANY_TYPE_DISTRIBUTOR.toString());
        model.addAttribute("map",map);
        //查询该公司下的公司列表
        List<SysCompany> companyList =  companyService.getSysCompanyLowLeverList(company.getId());
        model.addAttribute("companyList",companyList);
        return SUBDISTRIBUTOR_LIST;
    }

    @RequestMapping("/getDetatilList/{id}")
    public String getDetatilList(Model model,@PathVariable Long id, FeeSettlement feeSettlement,HttpServletRequest request){
        SysCompany sysCompany =companyService.selectById(id);
        model.addAttribute("company",sysCompany);
        feeSettlement.setSysCompany(sysCompany);
        if(sysCompany!=null){

            if(2==sysCompany.getCompanyType()){
                request.getSession().setAttribute("feeSettlement",feeSettlement);
                return   DISTRIBUTOR_DETATIL;
            }

        }
        return null;
    }


    @RequestMapping("/getDistributorListDataByID")
    @ResponseBody
    public String getDistributorListDataByID(HttpServletRequest request, Model model, FeeSettlement feeSettlement) {
        SysCompany company = (SysCompany) request.getSession().getAttribute("company");
        if (company == null) {
            return "";
        }
        Page<Map<String, String>> page = this.getPage();
        feeSettlement.setParentID(company.getId());
        feeSettlement.setSysType(SysCompany.COMPANY_TYPE_DISTRIBUTOR.toString());
        feeSettlement.setSysCompany(company);
        feeSettlementService.findPage(page, feeSettlement, feeSettlement.getSysType());
        return jsonPage(page);
    }


    /**
     * 明细内容
     * @return
     */
    @RequestMapping("/getDetatilListData")
    @ResponseBody
    public String getDetatilListData(FeeSettlement feeSettlement,HttpServletRequest request){
        FeeSettlement fee= (FeeSettlement) request.getSession().getAttribute("feeSettlement");
        if(fee!=null){
            feeSettlement.setsDate(fee.getsDate());
            feeSettlement.seteDate(fee.geteDate());
        }

        Page<Map<String,String>> page =this.getPage();
        feeSettlementService.findPage(page,feeSettlement,null);
        return jsonPage(page);
    }



    @RequestMapping("/getOrderNum")
    @ResponseBody
    public Map<String,Object> getOrderNum(HttpServletRequest request,Model model,String companyId,FeeSettlement feeSettlement){
        SysCompany  company = (SysCompany) request.getSession().getAttribute("company");
        Map<String,Object> map= null;
        if(company==null){
            map.put("totalNum","0");
            map.put("totalMoney","0");
        }
        Map<String,Object> param=  new HashMap<>();
        param.put("sDate",feeSettlement.getsDate());
        param.put("eDate",feeSettlement.geteDate());
        param.put("sysCompanyId",feeSettlement.getSysCompanyId());// 这个是分销商的id
        param.put("likeValue",feeSettlement.getLikeValue());
        param.put("parentID",company.getId());
        map=feeSettlementService.findFeeSettlementSubTongJi(param);
        return map;
    }




}
