// +----------------------------------------------------------------------
// | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
// +----------------------------------------------------------------------
// | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
// +----------------------------------------------------------------------
// | Author: CRMEB Team <admin@crmeb.com>
// +----------------------------------------------------------------------

import Vue from 'vue';
import Router from 'vue-router';

Vue.use(Router);

/* Layout */
import Layout from '@/layout';

/* Router Modules */
import distributionRouter from './modules/distribution';

export const constantRoutes = [
  // 分销员业绩报表
  {
    path: '/distribution/earningReport/distributionPeople',
    component: () => import('@/views/distribution/earningReport/distributionPeople'),
    hidden: true,
  },

  // 分销商业绩报表
  {
    path: '/distribution/earningReport/distributionCompany',
    component: () => import('@/views/distribution/earningReport/distributionCompany'),
    hidden: true
  },

  // 渠道商业绩报表
  {
    path: '/distribution/earningReport/channelCommission',
    component: () => import('@/views/distribution/earningReport/channelCommission'),
    hidden: true
  },

  // 分销员业绩账单
  {
    path: '/distribution/performanceBill/distributor',
    component: () => import('@/views/distribution/performanceBill/distributor'),
    hidden: true
  },

  // 分销商业绩账单
  {
    path: '/distribution/performanceBill/companyBill',
    component: () => import('@/views/distribution/performanceBill/companyBill'),
    hidden: true
  },

  // 渠道商业绩账单
  {
    path: '/distribution/performanceBill/channelBill',
    component: () => import('@/views/distribution/performanceBill/channelBill'),
    hidden: true
  },
  // 账单详情
  {
    path: '/distribution/performanceBill/performanceBillDetail',
    component: () => import('@/views/distribution/performanceBill/performanceBillDetail'),
    hidden: true
  },

  {
    path: '/404',
    component: () => import('@/views/error-page/404'),
    hidden: true,
  },

  {
    path: '/redirect',
    component: Layout,
    hidden: true,
    children: [
      {
        path: '/redirect/:path(.*)',
        component: () => import('@/views/redirect/index'),
      },
    ],
  },

  {
    path: '/login',
    component: () => import('@/views/login/index'),
    hidden: true,
  },

  {
    path: '/auth-redirect',
    component: () => import('@/views/login/auth-redirect'),
    hidden: true,
  },

  {
    path: '/401',
    component: () => import('@/views/error-page/401'),
    hidden: true,
  },

  {
    path: '/',
    component: Layout,
    redirect: '/dashboard',
    children: [
      {
        path: 'dashboard',
        component: () => import('@/views/dashboard/index'),
        name: 'Dashboard',
        meta: { title: '主页', icon: 'dashboard', affix: true },
      },
    ],
  },

  {
    path: '/setting/uploadPicture',
    component: () => import('@/components/base/uploadPicture.vue'),
    name: 'uploadPicture',
  },

  // 404 page must be placed at the end !!!
  { path: '*', redirect: '/404', hidden: true },
];

/**
 * asyncRoutes
 * the routes that need to be dynamically loaded based on user roles
 */
export const asyncRoutes = [];

const createRouter = () =>
  new Router({
    mode: 'history', // require service support
    // mode: 'hash',
    scrollBehavior: () => ({ y: 0 }),
    routes: constantRoutes,
  });

const router = createRouter();

// Detail see: https://github.com/vuejs/vue-router/issues/1234#issuecomment-357941465
export function resetRouter () {
  const newRouter = createRouter();
  router.matcher = newRouter.matcher; // reset router
}

export default router;
