/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.autodownloadupload.scheduling;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.bcxin.autodownloadupload.configs.PullConfig;
import com.bcxin.autodownloadupload.entity.PullRecord;
import com.bcxin.autodownloadupload.service.PullDataService;
import com.bcxin.autodownloadupload.service.PullRecordService;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PullDataTask {
    private static final Logger log = LoggerFactory.getLogger(PullDataTask.class);
    @Autowired
    private PullDataService pullDataService;
    @Autowired
    private PullRecordService pullRecordService;
    @Autowired
    private PullConfig pullConfig;

    @Scheduled(cron="${pull-config.scheduled.cron}")
    public void pullDataTask() {
        log.info("===================================\u5b9a\u65f6\u62c9\u53d6\u6570\u636e\u8c03\u5ea6\u4efb\u52a1===================================");
        Date now = new Date();
        ArrayList<String> regionCodes = new ArrayList<String>();
        for (String regionCode : this.pullConfig.getChangeLogsRequestDto().getRegionCodes().split(",")) {
            PullRecord lastRecord = this.pullRecordService.getLastRecord(regionCode);
            DateTime todayZero = DateUtil.beginOfDay((Date)now);
            long twoHour = 0x6DDD00L;
            if (todayZero.getTime() - lastRecord.getEndTime().getTime() <= twoHour) continue;
            regionCodes.add(regionCode);
        }
        if (CollectionUtil.isNotEmpty(regionCodes)) {
            this.pullConfig.getChangeLogsRequestDto().setRegionCodes(String.join((CharSequence)",", regionCodes));
            this.pullDataService.pullData(this.pullConfig.getChangeLogsRequestDto(), 0);
        }
        log.info("===================================\u4efb\u52a1\u7ed3\u675f===================================");
    }
}

