/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.infrastructures;

import com.bcxin.tenant.bcx.infrastructures.ContextAware;
import com.bcxin.tenant.bcx.infrastructures.UserDetailResponse;
import com.bcxin.tenant.bcx.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import com.bcxin.tenant.bcx.infrastructures.utils.StringUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class TenantEmployeeContext
implements ContextAware<TenantUserModel> {
    public static final String CURRENT_TENANT_USER_INFO = "API.CURRENT_TENANT_USER_INFO";
    private static final ThreadLocal<TenantUserModel> _userContextThread = new ThreadLocal();
    private Supplier<Collection<TenantDeviceDeskServiceScopeModel>> deviceDeskServiceScopesSupplier;
    private Supplier<TenantSecurityEmployeeModel> tenantSecurityEmployeeSupplier;

    @Override
    public TenantUserModel get() {
        return _userContextThread.get();
    }

    @Override
    public void init(TenantUserModel data) {
        _userContextThread.set(data);
    }

    public TenantUserModel init(UserDetailResponse userDetailResponse, PermissionModel permissionModel) {
        TenantUserModel userModel = TenantUserModel.create(userDetailResponse.getId(), userDetailResponse.getEmployeeId(), userDetailResponse.getName(), userDetailResponse.getIdCardNo(), userDetailResponse.getOrganizationId(), userDetailResponse.getCLevel(), userDetailResponse.getImNum(), userDetailResponse.getSupervise(), permissionModel);
        userModel.assignOrganizationInfo(OrganizationInfoModel.create(userDetailResponse.getOrgName(), userDetailResponse.getOrgLatitude(), userDetailResponse.getOrgLongitude(), userDetailResponse.getInstitutional(), userDetailResponse.getSuperviseRegionCode()));
        _userContextThread.set(userModel);
        return userModel;
    }

    public void reset() {
        _userContextThread.set(null);
    }

    public static class TenantUserModel
    implements Serializable {
        private static final long serialVersionUID = 8880000001L;
        private String id;
        private final String employeeId;
        private final String name;
        private final String idCardNo;
        private final String organizationId;
        private final int cLevel;
        private final PermissionModel permission;
        private final String imNum;
        private final boolean supervise;
        private Collection<TenantDeviceDeskServiceScopeModel> deviceDeskServiceScopes;
        private TenantSecurityEmployeeModel tenantSecurityEmployee;
        private OrganizationInfoModel organizationInfo;
        private String trafficTag;

        public MetaCreatorReferenceType getUserType() {
            return MetaCreatorReferenceType.Platform;
        }

        public Map<String, Object> fillAndReturnMap(Map<String, Object> map) {
            TenantUserModel userModel = this;
            HashMap<String, String> userInfo = new HashMap<String, String>();
            userInfo.put("id", userModel.getId());
            userInfo.put("name", userModel.getName());
            userInfo.put("organizationId", userModel.getOrganizationId());
            userInfo.put("domainId", userModel.getOrganizationId());
            userInfo.put("cLevel", String.valueOf(userModel.getCLevel()));
            userInfo.put("imNum", userModel.getImNum());
            userInfo.put("supervise", userModel.isSupervise() ? "1" : "0");
            userInfo.put("employeeId", userModel.getEmployeeId());
            userInfo.put("idCardNo", userModel.getIdCardNo());
            map.put("current", userInfo);
            map.put("idCardNo", userModel.getIdCardNo());
            map.put("current_id", userModel.getId());
            map.put("current_organizationId", userModel.getOrganizationId());
            return map;
        }

        public Double getOrgLatitude() {
            if (this.organizationInfo == null) {
                return null;
            }
            return this.organizationInfo.getLatitude();
        }

        public Double getOrgLongitude() {
            if (this.organizationInfo == null) {
                return null;
            }
            return this.organizationInfo.getLongitude();
        }

        public String getOrgInstitutional() {
            if (this.organizationInfo == null) {
                return null;
            }
            return this.organizationInfo.getInstitutional();
        }

        public String getSuperviseRegionCode() {
            if (this.organizationInfo == null) {
                return null;
            }
            return this.organizationInfo.getSuperviseRegionCode();
        }

        public String getTrafficTag() {
            if (this.trafficTag == null) {
                try {
                    this.trafficTag = this.getSuperviseRegionCode().substring(0, 3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.trafficTag;
        }

        public String getOrgName() {
            if (this.organizationInfo == null) {
                return null;
            }
            return this.organizationInfo.getName();
        }

        public boolean isDomainAdmin() {
            PermissionModel permissionModel = this.getPermission();
            if (permissionModel == null) {
                return false;
            }
            return this.getPermission().isDomainAdmin();
        }

        public String[] getNoSuperviseScopePermissions() {
            HashSet<String> allScopes = new HashSet<String>();
            if (this.permission != null && this.permission.getSubScopeCompanyIds() != null) {
                allScopes.addAll(this.permission.getSubScopeCompanyIds());
            }
            allScopes.add(this.getOrganizationId());
            return (String[])allScopes.toArray(String[]::new);
        }

        public void assignDeviceDeskServiceScopes(Collection<TenantDeviceDeskServiceScopeModel> deviceDeskServiceScopes) {
            this.deviceDeskServiceScopes = deviceDeskServiceScopes;
        }

        public void assignTenantSecurityEmployee(TenantSecurityEmployeeModel tenantSecurityEmployee) {
            this.tenantSecurityEmployee = tenantSecurityEmployee;
        }

        public void assignOrganizationInfo(OrganizationInfoModel organizationInfo) {
            this.organizationInfo = organizationInfo;
        }

        public String[] getAssignedSuperviseDepartIds() {
            if (this.getDeviceDeskServiceScopes() == null) {
                return new String[0];
            }
            Collection superviseDepartIds = this.getValidDeskServiceScopes().stream().map(ix -> ix.getAssignedSuperviseDepartId()).filter(ix -> !StringUtil.isEmpty(ix) && !ix.equalsIgnoreCase("#1")).collect(Collectors.toList());
            return superviseDepartIds.toArray(new String[superviseDepartIds.size()]);
        }

        private Collection<TenantDeviceDeskServiceScopeModel> getValidDeskServiceScopes() {
            if (this.getDeviceDeskServiceScopes() == null || this.getDeviceDeskServiceScopes().isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            Timestamp now = Timestamp.from(Instant.now());
            return this.getDeviceDeskServiceScopes().stream().filter(ix -> {
                Timestamp beginDate = ix.getBeginDate();
                if (beginDate == null) {
                    beginDate = Timestamp.from(Instant.MIN);
                }
                boolean flag = beginDate.before(now) && ix.getEndDate().after(now) || ix.getEndDate() == null;
                return flag;
            }).collect(Collectors.toList());
        }

        public Collection<String> getRelativeSameSelectedDepartIds(Collection<String> departIds) {
            if (departIds == null || departIds.isEmpty()) {
                return departIds;
            }
            Collection<TenantDeviceDeskServiceScopeModel> scopeModels = this.getValidDeskServiceScopes();
            if (scopeModels == null || scopeModels.isEmpty()) {
                return departIds;
            }
            Set unionMatchedDepartIds = scopeModels.stream().filter(ii -> departIds.contains(ii.getId())).map(ii -> ii.getAssignedSuperviseDepartId()).collect(Collectors.toSet());
            HashSet<String> mergedDepartIds = new HashSet<String>();
            mergedDepartIds.addAll(departIds);
            mergedDepartIds.addAll(unionMatchedDepartIds);
            return mergedDepartIds;
        }

        public boolean isSuperviseDepartRole() {
            return this.isSupervise();
        }

        public String getSecurityStationId() {
            TenantSecurityEmployeeModel securityEmployee = this.getTenantSecurityEmployee();
            if (securityEmployee == null) {
                return null;
            }
            return securityEmployee.getSecurityStationId();
        }

        public String getSuperviseDepartId() {
            TenantSecurityEmployeeModel securityEmployee = this.getTenantSecurityEmployee();
            if (securityEmployee == null) {
                return null;
            }
            return securityEmployee.getSuperviseDepartId();
        }

        public String getSuperviseDepartName() {
            TenantSecurityEmployeeModel securityEmployee = this.getTenantSecurityEmployee();
            if (securityEmployee == null) {
                return null;
            }
            return securityEmployee.getSuperviseDepartName();
        }

        public String getTenantUserIdCard() {
            TenantSecurityEmployeeModel securityEmployee = this.getTenantSecurityEmployee();
            if (securityEmployee == null) {
                return null;
            }
            return securityEmployee.getTenantUserIdCard();
        }

        private TenantUserModel(String id, String employeeId, String name, String idCardNo, String organizationId, int cLevel, String imNum, Boolean supervise, PermissionModel permission) {
            this.id = id;
            this.employeeId = employeeId;
            this.name = name;
            this.idCardNo = idCardNo;
            this.organizationId = organizationId;
            this.cLevel = cLevel;
            this.permission = permission;
            this.imNum = imNum;
            this.supervise = supervise == null ? false : supervise;
        }

        public static TenantUserModel create(String id, String employeeId, String name, String idCardNo, String organizationId, int cLevel, String imNum, Boolean supervise, PermissionModel permission) {
            return new TenantUserModel(id, employeeId, name, idCardNo, organizationId, cLevel, imNum, supervise, permission);
        }

        public String getId() {
            return this.id;
        }

        public String getEmployeeId() {
            return this.employeeId;
        }

        public String getName() {
            return this.name;
        }

        public String getIdCardNo() {
            return this.idCardNo;
        }

        public String getOrganizationId() {
            return this.organizationId;
        }

        public int getCLevel() {
            return this.cLevel;
        }

        public PermissionModel getPermission() {
            return this.permission;
        }

        public String getImNum() {
            return this.imNum;
        }

        public boolean isSupervise() {
            return this.supervise;
        }

        public Collection<TenantDeviceDeskServiceScopeModel> getDeviceDeskServiceScopes() {
            return this.deviceDeskServiceScopes;
        }

        public TenantSecurityEmployeeModel getTenantSecurityEmployee() {
            return this.tenantSecurityEmployee;
        }

        private OrganizationInfoModel getOrganizationInfo() {
            return this.organizationInfo;
        }
    }

    public static class PermissionModel
    implements Serializable {
        private static final long serialVersionUID = 8880000005L;
        private final boolean domainAdmin;
        private final Set<String> responsibleOfStationIds;
        private final List<String> selectedStationIds;
        private final Set<String> subScopeCompanyIds;
        private final Timestamp createdTime;
        private final String trace;

        public PermissionModel(boolean domainAdmin, Set<String> responsibleOfStationIds, List<String> selectedStationIds, Collection<String> subScopeCompanyIds, String trace) {
            this.domainAdmin = domainAdmin;
            if (responsibleOfStationIds != null) {
                responsibleOfStationIds = responsibleOfStationIds.stream().filter(ii -> !"#1".equalsIgnoreCase((String)ii)).collect(Collectors.toSet());
            }
            this.responsibleOfStationIds = responsibleOfStationIds;
            this.subScopeCompanyIds = subScopeCompanyIds == null ? new HashSet<String>() : subScopeCompanyIds.stream().collect(Collectors.toSet());
            this.selectedStationIds = selectedStationIds == null ? new ArrayList<String>() : selectedStationIds.stream().filter(ii -> !BusinessConstants.isRelativeProjectIdStuffId(ii)).filter(ii -> !ii.equalsIgnoreCase("#1")).collect(Collectors.toList());
            this.trace = trace;
            this.createdTime = Timestamp.from(Instant.now());
        }

        public static PermissionModel create(boolean domainAdmin, Set<String> responsibleOfStationIds, List<String> selectedStationIds, Collection<String> subScopeCompanyIds, String trace) {
            return new PermissionModel(domainAdmin, responsibleOfStationIds, selectedStationIds, subScopeCompanyIds, trace);
        }

        public boolean isDomainAdmin() {
            return this.domainAdmin;
        }

        public Set<String> getResponsibleOfStationIds() {
            return this.responsibleOfStationIds;
        }

        public List<String> getSelectedStationIds() {
            return this.selectedStationIds;
        }

        public Set<String> getSubScopeCompanyIds() {
            return this.subScopeCompanyIds;
        }

        public Timestamp getCreatedTime() {
            return this.createdTime;
        }

        public String getTrace() {
            return this.trace;
        }
    }

    public static class OrganizationInfoModel
    implements Serializable {
        private static final long serialVersionUID = 8880000004L;
        private Double latitude;
        private Double longitude;
        private String institutional;
        private String superviseRegionCode;
        private String name;

        public static OrganizationInfoModel create(String name, Double latitude, Double longitude, String institutional, String superviseRegionCode) {
            OrganizationInfoModel organization = new OrganizationInfoModel();
            organization.institutional = institutional;
            organization.latitude = latitude;
            organization.longitude = longitude;
            organization.name = name;
            organization.superviseRegionCode = superviseRegionCode;
            return organization;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        public String getInstitutional() {
            return this.institutional;
        }

        public String getSuperviseRegionCode() {
            return this.superviseRegionCode;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class TenantSecurityEmployeeModel
    implements Serializable {
        private static final long serialVersionUID = 8880000003L;
        private final String securityStationId;
        private final String securityStationName;
        private final String superviseDepartId;
        private final String superviseDepartName;
        private final String tencentUserId;
        private final String tenantUserName;
        private final String tenantUserIdCard;
        private final Set<String> resourceTypes;
        private final Timestamp dataCreatedTime;

        public TenantSecurityEmployeeModel(String securityStationId, String securityStationName, String superviseDepartId, String tencentUserId, String tenantUserName, String tenantUserIdCard, String superviseDepartName, Set<String> resourceTypes, Timestamp dataCreatedTime) {
            this.securityStationId = securityStationId;
            this.securityStationName = securityStationName;
            this.superviseDepartId = superviseDepartId;
            this.tencentUserId = tencentUserId;
            this.tenantUserName = tenantUserName;
            this.tenantUserIdCard = tenantUserIdCard;
            this.superviseDepartName = superviseDepartName;
            this.resourceTypes = resourceTypes;
            this.dataCreatedTime = dataCreatedTime;
        }

        public static TenantSecurityEmployeeModel create(String securityStationId, String securityStationName, String superviseDepartId, String tencentUserId, String tenantUserName, String tenantUserIdCard, String superviseDepartName, Set<String> resourceTypes, Timestamp dataCreatedTime) {
            return new TenantSecurityEmployeeModel(securityStationId, securityStationName, superviseDepartId, tencentUserId, tenantUserName, tenantUserIdCard, superviseDepartName, resourceTypes, dataCreatedTime);
        }

        public String getSecurityStationId() {
            return this.securityStationId;
        }

        public String getSecurityStationName() {
            return this.securityStationName;
        }

        public String getSuperviseDepartId() {
            return this.superviseDepartId;
        }

        public String getSuperviseDepartName() {
            return this.superviseDepartName;
        }

        public String getTencentUserId() {
            return this.tencentUserId;
        }

        public String getTenantUserName() {
            return this.tenantUserName;
        }

        public String getTenantUserIdCard() {
            return this.tenantUserIdCard;
        }

        public Set<String> getResourceTypes() {
            return this.resourceTypes;
        }

        public Timestamp getDataCreatedTime() {
            return this.dataCreatedTime;
        }
    }

    public static class TenantDeviceDeskServiceScopeModel
    implements Serializable {
        private static final long serialVersionUID = 8880000002L;
        private final String id;
        private final String name;
        private final String number;
        private final Timestamp beginDate;
        private final Timestamp endDate;
        private final String boundEmployeeId;
        private final String assignedSuperviseDepartId;
        private final String ipAddress;
        private final String organizationId;
        private final byte ir;

        public boolean isActive() {
            if (this.getBeginDate() == null || this.getEndDate() == null) {
                return false;
            }
            Date currentDate = Calendar.getInstance().getTime();
            return currentDate.after(this.getBeginDate()) && currentDate.before(this.getEndDate());
        }

        public TenantDeviceDeskServiceScopeModel(String id, String name, String number, Timestamp beginDate, Timestamp endDate, String boundEmployeeId, String assignedSuperviseDepartId, String ipAddress, String organizationId, byte ir) {
            this.id = id;
            this.name = name;
            this.number = number;
            this.beginDate = beginDate;
            this.endDate = endDate;
            this.boundEmployeeId = boundEmployeeId;
            this.assignedSuperviseDepartId = assignedSuperviseDepartId;
            this.ipAddress = ipAddress;
            this.organizationId = organizationId;
            this.ir = ir;
        }

        public static TenantDeviceDeskServiceScopeModel create(String id, String name, String number, Timestamp beginDate, Timestamp endDate, String boundEmployeeId, String assignedSuperviseDepartId, String ipAddress, String organizationId, byte ir) {
            return new TenantDeviceDeskServiceScopeModel(id, name, number, beginDate, endDate, boundEmployeeId, assignedSuperviseDepartId, ipAddress, organizationId, ir);
        }

        public String toString() {
            return String.format("\u8c03\u5ea6\u53f0:%s;\u6709\u6548\u671f:%s~%s", this.getNumber(), this.getBeginDate(), this.getEndDate());
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getNumber() {
            return this.number;
        }

        public Timestamp getBeginDate() {
            return this.beginDate;
        }

        public Timestamp getEndDate() {
            return this.endDate;
        }

        public String getBoundEmployeeId() {
            return this.boundEmployeeId;
        }

        public String getAssignedSuperviseDepartId() {
            return this.assignedSuperviseDepartId;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getOrganizationId() {
            return this.organizationId;
        }

        public byte getIr() {
            return this.ir;
        }
    }
}

