/*
 * Decompiled with CFR 0.152.
 */
package com.baichuanxin.openrestapi.service.impl;

import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.common.utils.OnlineTaskUtil;
import com.baichuanxin.openrestapi.dao.mapper.NoticeMapper;
import com.baichuanxin.openrestapi.entity.Notice;
import com.baichuanxin.openrestapi.service.NoticeService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NoticeServiceImpl
extends ServiceImpl<NoticeMapper, Notice>
implements NoticeService {
    private static final Logger log = LoggerFactory.getLogger(NoticeServiceImpl.class);
    @Autowired
    private NoticeMapper noticeMapper;

    public void getNotice(String noticeData) {
        Notice notice = (Notice)JSON.parseObject((String)noticeData, Notice.class);
        Notice noticeById = (Notice)this.noticeMapper.selectById((Serializable)((Object)notice.getTaskId()));
        if (noticeById == null) {
            this.noticeMapper.insert((Object)notice);
        } else {
            HashMap<String, String> confirmMap = new HashMap<String, String>();
            confirmMap.put("confirmType", "0");
            OnlineTaskUtil.taskConfirm((String)notice.getTaskId(), confirmMap);
            log.info("========================\u5f53\u524dtaskID\u5df2\u5b58\u5728{}", (Object)notice.getTaskId());
        }
    }

    public Notice getUnFinishTask() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)0)).last("limit 1");
        return (Notice)this.getOne((Wrapper)queryWrapper);
    }

    public boolean updateNoticeStatus(String taskId, int status, int fileStatus) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"taskId", (Object)taskId);
        updateWrapper.set((Object)"status", (Object)status);
        updateWrapper.set((Object)"fileStatus", (Object)fileStatus);
        return this.update((Wrapper)updateWrapper);
    }

    public boolean updateNoticeSentFileStatus(String taskId, int fileStatus) {
        return false;
    }

    public int updateNoticeOneByTaskId(Notice notice) {
        int i = this.noticeMapper.updateById((Object)notice);
        log.info("==============Notice\u529e\u4ef6\u6570\u636e\u5df2\u7ecf\u83b7\u53d6,taskId:{}=============", (Object)notice.getTaskId());
        return i;
    }

    public List<Notice> getUnReturnList(int status, int fileStatus, String matId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"status", (Object)status);
        queryWrapper.eq((Object)"fileStatus", (Object)fileStatus);
        queryWrapper.eq((Object)"matId", (Object)matId);
        return this.list((Wrapper)queryWrapper);
    }

    public List<Notice> getUnReturnListBymatIdList(int status, List<String> matIdList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"matId", matIdList);
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)status)).last("limit 10");
        return this.list((Wrapper)queryWrapper);
    }

    public List<Notice> getUnSentResultFile(String matId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"matId", (Object)matId);
        queryWrapper.eq((Object)"fileStatus", (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    public List<Notice> getCheckTaskFile() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"status", (Object)"1");
        queryWrapper.eq((Object)"fileStatus", (Object)"0");
        queryWrapper.in((Object)"matId", new Object[]{"4e73cab123ad4369a6b0bb30c726e8c2", "e34482ea3e1a40cd98ad7fc2603f7b72"});
        queryWrapper.orderByAsc((Object)"createTime");
        return this.list((Wrapper)queryWrapper);
    }
}

