/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.signature.service.impls;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.codec.Base64Encoder;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.backend.domain.enums.HnCertCatalog;
import com.bcxin.backend.domain.models.Result;
import com.bcxin.backend.domain.models.SignatureQueuesDTO;
import com.bcxin.backend.domain.repositories.SignatureQueuesRepository;
import com.bcxin.backend.domain.services.impls.ConvertServiceImpl;
import com.bcxin.backend.domain.signature.service.QzSignatureStrategy;
import com.bcxin.backend.domain.signature.service.impls.HuNanECUtil;
import com.bcxin.backend.domain.utils.FileUtils;
import com.bcxin.backend.domain.utils.JwtUtil;
import com.google.common.collect.Maps;
import io.jsonwebtoken.lang.Collections;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class HuNanInSignatureToPDFCompare
implements QzSignatureStrategy {
    private static final Logger log = LoggerFactory.getLogger(HuNanInSignatureToPDFCompare.class);
    private final SignatureQueuesRepository signatureQueuesRepository;
    @Value(value="${myapps.domain.url}")
    String urlHead;
    @Value(value="${myapps.signature.tempPDF}")
    String tempPDF;
    @Value(value="${myapps.signature.mobanPDF}")
    String mobanPDF;
    @Value(value="${myapps.signature.cgiApi}")
    String cgiApi;
    @Value(value="${myapps.storage.root}")
    String rootPath;
    @Value(value="${myapps.supervise.target-app}")
    String targetApp;
    @Autowired
    private ConvertServiceImpl convertService;
    private static String jwt_token = "";
    private static final String BASE64_PREFIX = "data:image/png;base64,";
    private static final String XML_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><license><catalog catalogId=\"%s\" catalogName=\"%s\" templateId=\"%s\" templateName=\"%s\" version=\"%s\"/><surface><item alias=\"holderCodeType\" code=\"certificateHolderTypeCode\" name=\"\u8bc1\u4ef6\u7c7b\u578b\" require=\"1\" value=\"\"/><item alias=\"issueUnitname\" catetype=\"0\" code=\"certificateIssuingAuthorityName\" name=\"\u9881\u8bc1\u5355\u4f4d\" require=\"1\" type=\"banzhengdanwei\" value=\"\"/><item alias=\"licenseNumber\" catetype=\"0\" code=\"certificateNumber\" name=\"\u8bc1\u7167\u7f16\u53f7\" require=\"1\" type=\"string\" value=\"\"/><item alias=\"issueDate\" catetype=\"0\" code=\"certificateIssuedDate\" dateFormat=\"yyyy-MM-dd\" name=\"\u9881\u8bc1\u65f6\u95f4\" require=\"1\" type=\"riqi\" value=\"\"/><item alias=\"validTimeBegin\" catetype=\"0\" code=\"certificateEffectiveDate\" dateFormat=\"yyyy-MM-dd\" name=\"\u6709\u6548\u671f\uff08\u8d77\u59cb\uff09\" require=\"1\" type=\"riqi\" value=\"\"/><item alias=\"holder\" catetype=\"0\" code=\"certificateHolderName\" name=\"\u6301\u8bc1\u8005\" require=\"1\" type=\"string\" value=\"\"/><item alias=\"validTimeEnd\" catetype=\"0\" code=\"certificateExpiringDate\" dateFormat=\"yyyy-MM-dd\" name=\"\u6709\u6548\u671f\uff08\u622a\u6b62\uff09\" require=\"1\" type=\"riqi\" value=\"\"/><item alias=\"holderCode\" catetype=\"0\" code=\"certificateHolderCode\" name=\"\u8bc1\u4ef6\u53f7\u7801\" require=\"1\" type=\"string\" value=\"\"/><item alias=\"csny\" catetype=\"1\" code=\"KZ_csny\" dateFormat=\"yyyy-MM-dd\" name=\"\u51fa\u751f\u5e74\u6708\" require=\"1\" type=\"riqi\" value=\"\"/><item alias=\"zz\" catetype=\"1\" code=\"KZ_zz\" name=\"\u4f4f\u5740\" require=\"1\" type=\"string\" value=\"\"/><item alias=\"zp\" catetype=\"1\" code=\"KZ_zp\" fileName=\"\" name=\"\u7167\u7247\" require=\"1\" type=\"tupian\" value=\"\"/><item alias=\"MJXM\" catetype=\"1\" code=\"KZ_MJXM\" name=\"\u6c11\u8b66\u59d3\u540d\" require=\"1\" type=\"string\" value=\"\"/><item alias=\"MJSFZHM\" catetype=\"1\" code=\"KZ_MJSFZHM\" name=\"\u6c11\u8b66\u8eab\u4efd\u8bc1\u53f7\u7801\" require=\"1\" type=\"string\" value=\"\"/><item alias=\"MJJH\" catetype=\"1\" code=\"KZ_MJJH\" name=\"\u6c11\u8b66\u8b66\u53f7\" require=\"0\" type=\"string\" value=\"\"/><item alias=\"YHID\" catetype=\"1\" code=\"KZ_YHID\" name=\"\u7528\u6237Id\" require=\"1\" type=\"string\" value=\"\"/><item alias=\"EWM\" catetype=\"1\" code=\"KZ_EWM\" name=\"\u4e8c\u7ef4\u7801\" require=\"1\" type=\"p_qrcode\" value=\"\"/></surface></license>";
    @Autowired
    @Qualifier(value="primaryJdbcTemplate")
    protected JdbcTemplate jdbcTemplate;

    public HuNanInSignatureToPDFCompare(SignatureQueuesRepository signatureQueuesRepository) {
        this.signatureQueuesRepository = signatureQueuesRepository;
    }

    private String getToken() {
        String token = "";
        if (StringUtils.isEmpty((CharSequence)jwt_token) || !JwtUtil.isTokenExpired(jwt_token)) {
            token = HuNanECUtil.getToken(this.cgiApi);
            jwt_token = JwtUtil.createJWT(token);
        } else {
            token = JwtUtil.parseData(jwt_token);
        }
        return token;
    }

    @Override
    public void cerSignatureQueues() {
        System.err.println("====> \u8bc1\u4e66\u8fc7\u6ee4\u751f\u6210\u6709\u6548\u7b7e\u7ae0\u8bb0\u5f55 \u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1acerSignatureQueues star................");
        String sqlQId = " select a.id from tlk_Certificate a where a.ITEM_signatured_processed_status IN (0) and a.ITEM_CERTIFICATETYPE='1' and a.ITEM_isCertified != '0' and instr(a.item_certificatefrom,'\u6e58\u6f6d') order by item_certificateDate desc, ITEM_signatured_time desc limit 300";
        List strList = this.jdbcTemplate.query(sqlQId, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("id");
            }
        });
        if (strList.size() == 0) {
            return;
        }
        String dupsql = "";
        String dupsql2 = "";
        String dupsql3 = "";
        String dupsql4 = "";
        String dupsql5 = "";
        String upsql = "";
        String insql = "";
        String insql2 = "";
        String insql3 = "";
        String insql4 = "";
        String insql5 = "";
        String operator = "";
        String now = DateUtil.today();
        String array = "(";
        for (String str : strList) {
            array = array + "'";
            array = array + str;
            array = array + "',";
        }
        array = array.substring(0, array.length() - 1);
        array = array + ")";
        String sql = "select id,item_securityname,item_documentid,item_idaddress,item_certificateno,item_certificatefrom,item_certificatedate,item_headphoto,created,item_signatured_processed_status from tlk_certificate where id in " + array + "";
        System.out.println(sql);
        List list = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, String>>(){

            public Map<String, String> mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap map = Maps.newHashMap();
                map.put("id", rs.getString("id"));
                map.put("item_securityname", rs.getString("item_securityname"));
                map.put("item_documentid", rs.getString("item_documentid"));
                map.put("item_idaddress", rs.getString("item_idaddress"));
                map.put("item_certificateno", rs.getString("item_certificateno"));
                map.put("item_certificatefrom", rs.getString("item_certificatefrom"));
                map.put("item_certificatedate", rs.getString("item_certificatedate"));
                map.put("item_headphoto", rs.getString("item_headphoto"));
                map.put("created", rs.getString("created"));
                map.put("item_signatured_processed_status", rs.getString("item_signatured_processed_status"));
                return map;
            }
        });
        if (list.size() > 0) {
            dupsql = "UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168' WHERE id in(";
            dupsql2 = "UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8eab\u4efd\u8bc1\u4fe1\u606f\u65e0\u6548' WHERE id in(";
            dupsql3 = "UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u4f4f\u5740\uff09' WHERE id in(";
            dupsql4 = "UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u5934\u50cf\uff09' WHERE id in(";
            dupsql5 = "UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u5934\u50cf\u3001\u8eab\u4efd\u8bc1\u4f4f\u5740\uff09' WHERE id in(";
            upsql = "UPDATE tlk_certificate SET ITEM_last_signatured_processed_result = '',ITEM_signatured_processed_status = 1,ITEM_signatured_operator = '" + operator + "',ITEM_signatured_time = now(),ITEM_CERTIFICATEDATE = IFNULL(ITEM_CERTIFICATEDATE, NOW()) WHERE id in(";
            insql = "INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES";
            insql2 = "INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES";
            insql3 = "INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES";
            insql4 = "INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES";
            insql5 = "INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES";
            int i = 0;
            for (Map map1 : list) {
                ++i;
                String created = (String)map1.get("created");
                String securityname = (String)map1.get("item_securityname");
                String documentid = (String)map1.get("item_documentid");
                String IdAddress = (String)map1.get("item_idaddress");
                String certificateno = (String)map1.get("item_certificateno");
                String certificatefrom = (String)map1.get("item_certificatefrom");
                String certificatedate = (String)map1.get("item_certificatedate");
                String headphoto = (String)map1.get("item_headphoto");
                String signaturestatus = (String)map1.get("item_signatured_processed_status");
                String id = (String)map1.get("id");
                if (StringUtils.isEmpty((CharSequence)signaturestatus)) continue;
                String string = signaturestatus = signaturestatus.contains(".") ? signaturestatus.split(".")[0] : signaturestatus;
                if (StringUtils.isEmpty((CharSequence)created)) {
                    created = DateUtil.today();
                }
                boolean boolean1 = true;
                if (StringUtils.isNotEmpty((CharSequence)documentid) && documentid.length() != 18) {
                    boolean1 = false;
                }
                boolean boolean2 = true;
                boolean boolean3 = true;
                boolean boolean4 = true;
                String IdAddressTemp = IdAddress;
                String string2 = IdAddress = StringUtils.isNotEmpty((CharSequence)IdAddress) ? IdAddress.trim() : IdAddress;
                if (StringUtils.isEmpty((CharSequence)IdAddress)) {
                    boolean2 = false;
                } else {
                    boolean endsWithRegion;
                    boolean bl = (IdAddress = IdAddress.replace("\uff0c", "")).endsWith("\u7701") ? true : (IdAddress.endsWith("\u5e02") ? true : (IdAddress.endsWith("\u533a") ? true : (endsWithRegion = IdAddress.endsWith("\u53bf"))));
                    if (endsWithRegion) {
                        boolean3 = false;
                    } else {
                        String[] arrAddr = IdAddressTemp.trim().split(" ");
                        if (arrAddr.length == 2) {
                            if (arrAddr[1].contains(arrAddr[0])) {
                                IdAddress = arrAddr[1];
                            } else if (arrAddr[1].contains(arrAddr[0].substring(0, 3))) {
                                IdAddress = arrAddr[1];
                            } else if (arrAddr[1].contains(arrAddr[0].substring(0, 2))) {
                                IdAddress = arrAddr[1];
                            }
                            IdAddress = IdAddress.replace(" ", "");
                        }
                    }
                }
                if (StringUtils.isEmpty((CharSequence)headphoto)) {
                    boolean2 = false;
                } else if (headphoto.contains("null") || headphoto.contains("b.photoUrl")) {
                    boolean4 = false;
                }
                if (StringUtils.isNotEmpty((CharSequence)securityname) && StringUtils.isNotEmpty((CharSequence)documentid) && StringUtils.isNotEmpty((CharSequence)IdAddress) && StringUtils.isNotEmpty((CharSequence)certificateno) && StringUtils.isNotEmpty((CharSequence)certificatefrom) && StringUtils.isNotEmpty((CharSequence)headphoto) && boolean1) {
                    com.alibaba.fastjson.JSONObject rtJsonStrData;
                    if (!"0".equals(signaturestatus) && !"3".equals(signaturestatus)) continue;
                    String[] arrphoto = headphoto.split("originalPath");
                    String[] arrphoto1 = headphoto.split("uid");
                    if (arrphoto.length == 2) {
                        headphoto = headphoto.replace("[", "");
                        headphoto = headphoto.replace("]", "");
                        rtJsonStrData = com.alibaba.fastjson.JSONObject.parseObject((String)headphoto);
                        headphoto = rtJsonStrData.get((Object)"path") + "";
                    } else if (arrphoto1.length == 2) {
                        headphoto = headphoto.replace("[", "");
                        headphoto = headphoto.replace("]", "");
                        rtJsonStrData = com.alibaba.fastjson.JSONObject.parseObject((String)headphoto);
                        headphoto = rtJsonStrData.get((Object)"path") + "";
                    }
                    String year = documentid.substring(6, 10);
                    String month = documentid.substring(10, 12);
                    String day = documentid.substring(12, 14);
                    String moban = this.mobanPDF;
                    certificatedate = StringUtils.isEmpty((CharSequence)certificatedate) ? DateUtil.today() : DateUtil.format((Date)DateUtil.parseDate((CharSequence)certificatedate), (String)"yyyy-MM-dd");
                    String json = "{\"name\":\"" + securityname + "\",\"address\":\"" + IdAddress + "\",\"headphoto\":\"" + headphoto + "\",\"idcardno\":\"" + documentid + "\",\"year\":\"" + year + "\",\"month\":\"" + month + "\",\"day\":\"" + day + "\",\"certificateno\":\"" + certificateno + "\",\"certificatefrom\":\"" + certificatefrom + "\",\"isSignature\":\"1\",\"fzDate\":\"" + certificatedate + "\"}";
                    if (i <= 200) {
                        insql = insql + "('" + moban + "','" + json + "',0,'" + id + "',NOW(),'" + operator + "','" + certificatedate + "'),";
                    } else if (i > 200 && i <= 400) {
                        insql2 = insql2 + "('" + moban + "','" + json + "',0,'" + id + "',NOW(),'" + operator + "','" + certificatedate + "'),";
                    } else if (i > 400 && i <= 600) {
                        insql3 = insql3 + "('" + moban + "','" + json + "',0,'" + id + "',NOW(),'" + operator + "','" + certificatedate + "'),";
                    } else if (i > 600 && i <= 800) {
                        insql4 = insql4 + "('" + moban + "','" + json + "',0,'" + id + "',NOW(),'" + operator + "','" + certificatedate + "'),";
                    } else {
                        insql5 = insql5 + "('" + moban + "','" + json + "',0,'" + id + "',NOW(),'" + operator + "','" + certificatedate + "'),";
                    }
                    upsql = upsql + "'" + id + "'";
                    upsql = upsql + ",";
                    continue;
                }
                if (!boolean1) {
                    dupsql2 = dupsql2 + "'" + id + "'";
                    dupsql2 = dupsql2 + ",";
                    continue;
                }
                if (!boolean2) {
                    dupsql5 = dupsql5 + "'" + id + "'";
                    dupsql5 = dupsql5 + ",";
                    continue;
                }
                if (!boolean3) {
                    dupsql3 = dupsql3 + "'" + id + "'";
                    dupsql3 = dupsql3 + ",";
                    continue;
                }
                if (!boolean4) {
                    dupsql4 = dupsql4 + "'" + id + "'";
                    dupsql4 = dupsql4 + ",";
                    continue;
                }
                dupsql = dupsql + "'" + id + "'";
                dupsql = dupsql + ",";
            }
        }
        if (!"INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES".equals(insql)) {
            insql = insql.substring(0, insql.length() - 1);
            this.jdbcTemplate.update(insql);
        }
        if (!"INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES".equals(insql2)) {
            insql2 = insql2.substring(0, insql2.length() - 1);
            this.jdbcTemplate.update(insql2);
        }
        if (!"INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES".equals(insql3)) {
            insql3 = insql3.substring(0, insql3.length() - 1);
            this.jdbcTemplate.update(insql3);
        }
        if (!"INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES".equals(insql4)) {
            insql4 = insql4.substring(0, insql4.length() - 1);
            this.jdbcTemplate.update(insql4);
        }
        if (!"INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES".equals(insql5)) {
            insql5 = insql5.substring(0, insql5.length() - 1);
            this.jdbcTemplate.update(insql5);
        }
        if (!("UPDATE tlk_certificate SET ITEM_last_signatured_processed_result = '',ITEM_signatured_processed_status = 1,ITEM_signatured_operator = '" + operator + "',ITEM_signatured_time = now(),ITEM_CERTIFICATEDATE = IFNULL(ITEM_CERTIFICATEDATE, NOW()) WHERE id in(").equals(upsql)) {
            upsql = upsql.substring(0, upsql.length() - 1);
            upsql = upsql + ");";
            this.jdbcTemplate.update(upsql);
        }
        if (!"UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168' WHERE id in(".equals(dupsql)) {
            dupsql = dupsql.substring(0, dupsql.length() - 1);
            dupsql = dupsql + ");";
            this.jdbcTemplate.update(dupsql);
        }
        if (!"UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8eab\u4efd\u8bc1\u4fe1\u606f\u65e0\u6548' WHERE id in(".equals(dupsql2)) {
            dupsql2 = dupsql2.substring(0, dupsql2.length() - 1);
            dupsql2 = dupsql2 + ");";
            this.jdbcTemplate.update(dupsql2);
        }
        if (!"UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u5934\u50cf\u3001\u8eab\u4efd\u8bc1\u4f4f\u5740\uff09' WHERE id in(".equals(dupsql5)) {
            dupsql5 = dupsql5.substring(0, dupsql5.length() - 1);
            dupsql5 = dupsql5 + ");";
            this.jdbcTemplate.update(dupsql5);
        }
        if (!"UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u4f4f\u5740\uff09' WHERE id in(".equals(dupsql3)) {
            dupsql3 = dupsql3.substring(0, dupsql3.length() - 1);
            dupsql3 = dupsql3 + ");";
            this.jdbcTemplate.update(dupsql3);
        }
        if (!"UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u5934\u50cf\uff09' WHERE id in(".equals(dupsql4)) {
            dupsql4 = dupsql4.substring(0, dupsql4.length() - 1);
            dupsql4 = dupsql4 + ");";
            this.jdbcTemplate.update(dupsql4);
        }
    }

    @Override
    public void cerPDF() {
        this.createPDF();
    }

    private boolean activateXMPSignQuicklyExCGI() {
        StringBuilder sb = new StringBuilder();
        try {
            com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
            json.put("service", (Object)"wss://127.0.0.1:8800");
            json.put("sn", (Object)"2171101001009256");
            json.put("pin", (Object)"88888888");
            json.put("in", (Object)"/data/share/in");
            json.put("out", (Object)"/data/share/out");
            JSONArray arr = new JSONArray();
            com.alibaba.fastjson.JSONObject pos = new com.alibaba.fastjson.JSONObject();
            pos.put("centerX", (Object)405);
            pos.put("centerY", (Object)312);
            pos.put("page", (Object)1);
            arr.add((Object)pos);
            json.put("signOnPos", (Object)arr);
            String ret = HttpUtil.post((String)this.cgiApi, (String)json.toJSONString());
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.activateXMPSignQuicklyExCGI.ret\uff1a" + ret);
            if (StringUtils.isEmpty((CharSequence)ret)) {
                return false;
            }
            com.alibaba.fastjson.JSONObject result = JSON.parseObject((String)ret.replace("#", ""));
            return "1".equals(String.valueOf(result.get((Object)"code")));
        }
        catch (Exception e) {
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.activateXMPSignQuicklyExCGI message:" + e.getMessage());
            return false;
        }
    }

    private void createPDF() {
        System.err.println("====> \u6709\u6548\u7b7e\u7ae0\u8bb0\u5f55\u67e5\u8be2\u6279\u91cf\u751f\u6210pdf\u6587\u4ef6 \u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1acreatePDF star................");
        Page<SignatureQueuesDTO> pageQueues = this.signatureQueuesRepository.pageQueues(0, PageRequest.of((int)0, (int)300));
        List queues = pageQueues.getContent();
        if (Collections.isEmpty((Collection)queues)) {
            return;
        }
        System.err.println("====> \u6709\u6548\u7b7e\u7ae0\u8bb0\u5f55\u67e5\u8be2\u6279\u91cf\u751f\u6210pdf\u6587\u4ef6 queues size\uff1a" + queues.size() + " ................");
        for (SignatureQueuesDTO queuesDTO : queues) {
            this.accept(queuesDTO);
        }
    }

    public static void main(String[] args) {
        String con = "{\"address\":\"\u5c71\u897f\u7701\u6cb3\u6d25\u5e02\u6a0a\u6751\u9547\u5e72\u6da7\u6751\",\"certificateno\":\"\u4eac2023254021\",\"day\":\"15\",\"fzDate\":\"2023-07-18\",\"headphoto\":\"https://02obs.baibaodun.cn/2024/10-11/1172a4fc-9357-4370-ab7b-c99f69c07f1c/1728630228970.jpg\",\"idcardno\":\"140882200411150018\",\"isSignature\":\"1\",\"month\":\"11\",\"name\":\"\u53f2\u6893\u5f6c\",\"unSignaturePDF\":\"/uploads/pdf/dianziqianzhang/temp/queueId_205459.temp\",\"year\":\"2004\",\"zDay\":\"18\",\"zMonth\":\"07\",\"zYear\":\"2023\"}";
        SignatureData data = (SignatureData)com.alibaba.fastjson.JSONObject.parseObject((String)con, SignatureData.class);
        System.out.println(HuNanInSignatureToPDFCompare.createHtml(data, "\u957f\u6c99\u5e02\u516c\u5b89\u5c40"));
    }

    private void accept(SignatureQueuesDTO queue) {
        Long a = System.currentTimeMillis();
        SignatureData data = (SignatureData)com.alibaba.fastjson.JSONObject.parseObject((String)queue.getData(), SignatureData.class);
        String selectSql = "SELECT a.name,b.number,e.AUTHOR author FROM obpm2_security.tenant_users a,obpm2_security.tenant_user_credentials b,obpm2_security.tenant_employees d,security_flow.tlk_certificate e WHERE a.id=b.tenant_user_id AND b.credential_type=0 AND a.id=d.tenant_user_id AND d.`status`=0 AND d.id = e.AUTHOR AND e.id='" + queue.getBusiness_id() + "';";
        Map map = this.jdbcTemplate.queryForMap(selectSql);
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.selectSql\uff1a" + selectSql);
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.map\uff1a" + map);
        String infile = this.tempPDF + "/" + DateUtil.today();
        String filename = System.currentTimeMillis() + "hnzgz_queueId_" + queue.getId() + ".ofd";
        String path = Paths.get(infile, filename).normalize().toString();
        String result = "";
        String message = "";
        String xml = this.handleXml(map, data, this.targetApp + path);
        Result ret = HuNanECUtil.xmlDataSend(this.cgiApi, xml, IdUtil.randomUUID(), this.getToken());
        if ("0".equals(ret.getRetType())) {
            result = ret.getData() + "";
            message = "\u8d44\u683c\u8bc1\u5df2\u7533\u8bf7\uff0c\u8bc1\u4e66\u7f16\u7801:" + result;
        } else {
            message = ret.getMsg();
        }
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.message\uff1a" + message);
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            this.signatureQueuesRepository.updateSignature(3, new Date(), message, queue.getId());
        } else {
            this.signatureQueuesRepository.updateSignature(2, new Date(), message, queue.getId());
        }
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u751f\u6210\u6587\u4ef6\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
    }

    private String handleXml(Map<String, Object> stringMap, SignatureData data, String previewUrl) {
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.handleXml.previewUrl\uff1a" + previewUrl);
        Document document = null;
        try {
            HnCertCatalog cert = HnCertCatalog.getByAreaName(data.getCertificatefrom());
            if (cert == null) {
                return "";
            }
            String xml = String.format(XML_TEMPLATE, cert.getCatalogId(), cert.getCatalogName(), cert.getTemplateId(), cert.getTemplateName(), cert.getVersion());
            document = DocumentHelper.parseText((String)xml);
            Element rootElement = document.getRootElement();
            Element surface = rootElement.element("surface");
            List itemElementList = surface.elements("item");
            block38: for (Element item : itemElementList) {
                String alias;
                switch (alias = item.attributeValue("alias")) {
                    case "holderCodeType": {
                        this.setItemValue(item, alias, "0");
                        continue block38;
                    }
                    case "issueUnitname": {
                        this.setItemValue(item, alias, cert.getIssueUnitname());
                        continue block38;
                    }
                    case "licenseNumber": {
                        this.setItemValue(item, alias, data.getCertificateno());
                        continue block38;
                    }
                    case "issueDate": {
                        this.setItemValue(item, alias, data.getFzDate());
                        continue block38;
                    }
                    case "validTimeBegin": {
                        this.setItemValue(item, alias, data.getFzDate());
                        continue block38;
                    }
                    case "holder": {
                        this.setItemValue(item, alias, data.getName());
                        continue block38;
                    }
                    case "validTimeEnd": {
                        this.setItemValue(item, alias, "\u957f\u671f");
                        continue block38;
                    }
                    case "holderCode": {
                        this.setItemValue(item, alias, data.getIdcardno());
                        continue block38;
                    }
                    case "csny": {
                        this.setItemValue(item, alias, data.getYear() + "-" + data.getMonth() + "-" + data.getDay());
                        continue block38;
                    }
                    case "zz": {
                        this.setItemValue(item, alias, data.getAddress());
                        continue block38;
                    }
                    case "zp": {
                        String imageUrl = data.getHeadphoto();
                        if (imageUrl == null || imageUrl.isEmpty()) {
                            System.err.println("\u56fe\u7247URL\u4e3a\u7a7a");
                            return "";
                        }
                        imageUrl = imageUrl.startsWith("http") ? imageUrl : this.urlHead + imageUrl;
                        String filename = "";
                        int lastSlashIndex = imageUrl.lastIndexOf(47);
                        if (lastSlashIndex != -1 && lastSlashIndex < imageUrl.length() - 1) {
                            filename = imageUrl.substring(lastSlashIndex + 1);
                        }
                        item.attribute("fileName").setValue(filename);
                        byte[] imageBytes = HttpUtil.downloadBytes((String)imageUrl);
                        String base64 = Base64Encoder.encode((byte[])imageBytes);
                        this.setItemValue(item, alias, base64);
                        continue block38;
                    }
                    case "MJXM": {
                        this.setItemValue(item, alias, stringMap.get("name") + "");
                        continue block38;
                    }
                    case "MJSFZHM": {
                        this.setItemValue(item, alias, stringMap.get("number") + "");
                        continue block38;
                    }
                    case "MJJH": {
                        this.setItemValue(item, alias, "");
                        continue block38;
                    }
                    case "YHID": {
                        this.setItemValue(item, alias, stringMap.get("author") + "");
                        continue block38;
                    }
                    case "EWM": {
                        String htmlContent = HuNanInSignatureToPDFCompare.createHtml(data, cert.getIssueUnitname());
                        this.setItemValue(item, alias, htmlContent);
                        continue block38;
                    }
                }
                System.err.println("\u672a\u77e5\u7684\u9879\u522b\u540d: " + alias);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return document.asXML();
    }

    private void setItemValue(Element item, String alias, String value) {
        if (item.attributeValue("alias").equals(alias)) {
            item.attribute("value").setValue(value);
        }
    }

    public static String createHtml(SignatureData data, String issueUnitname) {
        String toDay = data.getFzDate();
        if (StringUtils.isEmpty((CharSequence)toDay)) {
            toDay = DateUtil.today();
        }
        String zDay = toDay.split("-")[2].substring(0, 2);
        String gender = "";
        char c = data.getIdcardno().charAt(data.getIdcardno().length() - 2);
        int genderBit = Integer.parseInt(String.valueOf(c));
        gender = genderBit % 2 == 0 ? "\u5973" : "\u7537";
        String htmlContent = "\u8bc1\u4ef6\u7f16\u53f7\uff1a" + data.getCertificateno() + "\n\u59d3   \u540d\uff1a" + data.getName() + "\n\u6027   \u522b\uff1a" + gender + "\n\u51fa\u751f\u5e74\u6708\uff1a" + data.getYear() + " \u5e74 " + data.getMonth() + " \u6708 " + data.getDay() + " \u65e5\n\u8eab\u4efd\u8bc1\u53f7\uff1a" + data.getIdcardno() + "\n\u4f4f   \u5740\uff1a" + data.getAddress() + "\n\u53d1\u8bc1\u673a\u5173\uff1a" + issueUnitname + "\n\u53d1\u8bc1\u65e5\u671f\uff1a" + toDay.split("-")[0] + " \u5e74 " + toDay.split("-")[1] + " \u6708 " + zDay + " \u65e5\n";
        return htmlContent;
    }

    private static String format(String content, Object formData) {
        JSONObject data = JSONObject.fromObject((Object)formData);
        String pattern = "\\$\\{(.+?)\\}";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String key = m.group(1);
            Object value = data.get(key);
            m.appendReplacement(sb, value == null ? "" : value.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public void delInPDF() {
    }

    @Override
    public void signQuicklyExCGI() {
        System.err.println("====> \u4e34\u65f6\u76ee\u5f55pdf\u526a\u5207\u5230in\u76ee\u5f55\u89e6\u53d1\u7b7e\u7ae0 \u5b9a\u65f6\u4efb\u52a1\uff1asignQuicklyExCGI() star ................");
        Long a = System.currentTimeMillis();
        Page<SignatureQueuesDTO> pageQueues = this.signatureQueuesRepository.pageQueues(3, PageRequest.of((int)0, (int)300));
        List queues = pageQueues.getContent();
        if (Collections.isEmpty((Collection)queues)) {
            return;
        }
        String infile = this.tempPDF + "/" + DateUtil.today();
        for (SignatureQueuesDTO queuesDTO : queues) {
            this.processQueue(queuesDTO, infile);
        }
        log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI.\u7b7e\u7ae0\u63a5\u53e3\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
    }

    private void processQueue(SignatureQueuesDTO queuesDTO, String infile) {
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI.processQueue.Last_processed_result\uff1a" + queuesDTO.getLast_processed_result());
        if (StringUtils.isEmpty((CharSequence)queuesDTO.getLast_processed_result())) {
            return;
        }
        String fileNumber = queuesDTO.getLast_processed_result().split("\u8bc1\u4e66\u7f16\u7801:")[1];
        String filename = System.currentTimeMillis() + "hnzgz_queueId_" + queuesDTO.getId() + ".ofd";
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI.processQueue.filename\uff1a" + filename);
        String path = Paths.get(infile, filename).normalize().toString();
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI.processQueue.path\uff1a" + path);
        String base64Str = HuNanECUtil.getFileRequest(this.cgiApi, fileNumber);
        if (StringUtils.isEmpty((CharSequence)base64Str)) {
            return;
        }
        FileUtils.mkdirs(this.rootPath + infile);
        byte[] bytes = Base64.decode((CharSequence)base64Str);
        File file = new File(this.rootPath + path);
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(bytes);
        }
        catch (IOException e) {
            System.err.println("\u5199\u5165\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
            return;
        }
        String updateSql = "UPDATE tlk_certificate SET ITEM_SIGNATURED_PROCESSED_STATUS=?, ITEM_LAST_SIGNATURED_PROCESSED_TIME=NOW(), ITEM_CERTIFICATEDATE=IFNULL(ITEM_CERTIFICATEDATE, NOW()), ITEM_LAST_SIGNATURED_PROCESSED_RESULT=?, ITEM_ATTACHMENT=? WHERE ID=?";
        this.jdbcTemplate.update(updateSql, new Object[]{"2", "\u5b8c\u6210", path, queuesDTO.getBusiness_id()});
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI.processQueue.updateSql\uff1a" + updateSql);
        this.signatureQueuesRepository.updateSignature(1, new Date(), fileNumber, queuesDTO.getId());
    }

    @Override
    public void changeStatus() {
        String updateSql = "update obpm2_security.signature_queues set status = '0' where status = '3' and !instr(last_processed_result,'\u8bc1\u4e66\u7f16\u7801:') and TIMESTAMPDIFF(HOUR, last_processed_time, NOW()) > 3";
        this.jdbcTemplate.update(updateSql);
    }

    @Override
    public void scan() {
    }

    public static class Resource {
        private int errcode;
        private String errmsg;
        private Object data;

        public int getErrcode() {
            return this.errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public Object getData() {
            return this.data;
        }

        public void setErrcode(int errcode) {
            this.errcode = errcode;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getErrcode() != other.getErrcode()) {
                return false;
            }
            String this$errmsg = this.getErrmsg();
            String other$errmsg = other.getErrmsg();
            if (this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Resource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getErrcode();
            String $errmsg = this.getErrmsg();
            result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "HuNanInSignatureToPDFCompare.Resource(errcode=" + this.getErrcode() + ", errmsg=" + this.getErrmsg() + ", data=" + this.getData() + ")";
        }
    }

    public static class SignatureData {
        private String name;
        private String address;
        private String headphoto;
        private String idcardno;
        private String year;
        private String month;
        private String day;
        private String certificateno;
        private String certificatefrom;
        private String isSignature;
        private String fzDate;
        private String zYear;
        private String zMonth;
        private String zDay;
        private String signatureImg;
        private String unSignaturePDF;
        private String signaturePDF;

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public String getHeadphoto() {
            return this.headphoto;
        }

        public String getIdcardno() {
            return this.idcardno;
        }

        public String getYear() {
            return this.year;
        }

        public String getMonth() {
            return this.month;
        }

        public String getDay() {
            return this.day;
        }

        public String getCertificateno() {
            return this.certificateno;
        }

        public String getCertificatefrom() {
            return this.certificatefrom;
        }

        public String getIsSignature() {
            return this.isSignature;
        }

        public String getFzDate() {
            return this.fzDate;
        }

        public String getZYear() {
            return this.zYear;
        }

        public String getZMonth() {
            return this.zMonth;
        }

        public String getZDay() {
            return this.zDay;
        }

        public String getSignatureImg() {
            return this.signatureImg;
        }

        public String getUnSignaturePDF() {
            return this.unSignaturePDF;
        }

        public String getSignaturePDF() {
            return this.signaturePDF;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setHeadphoto(String headphoto) {
            this.headphoto = headphoto;
        }

        public void setIdcardno(String idcardno) {
            this.idcardno = idcardno;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public void setDay(String day) {
            this.day = day;
        }

        public void setCertificateno(String certificateno) {
            this.certificateno = certificateno;
        }

        public void setCertificatefrom(String certificatefrom) {
            this.certificatefrom = certificatefrom;
        }

        public void setIsSignature(String isSignature) {
            this.isSignature = isSignature;
        }

        public void setFzDate(String fzDate) {
            this.fzDate = fzDate;
        }

        public void setZYear(String zYear) {
            this.zYear = zYear;
        }

        public void setZMonth(String zMonth) {
            this.zMonth = zMonth;
        }

        public void setZDay(String zDay) {
            this.zDay = zDay;
        }

        public void setSignatureImg(String signatureImg) {
            this.signatureImg = signatureImg;
        }

        public void setUnSignaturePDF(String unSignaturePDF) {
            this.unSignaturePDF = unSignaturePDF;
        }

        public void setSignaturePDF(String signaturePDF) {
            this.signaturePDF = signaturePDF;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SignatureData)) {
                return false;
            }
            SignatureData other = (SignatureData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$headphoto = this.getHeadphoto();
            String other$headphoto = other.getHeadphoto();
            if (this$headphoto == null ? other$headphoto != null : !this$headphoto.equals(other$headphoto)) {
                return false;
            }
            String this$idcardno = this.getIdcardno();
            String other$idcardno = other.getIdcardno();
            if (this$idcardno == null ? other$idcardno != null : !this$idcardno.equals(other$idcardno)) {
                return false;
            }
            String this$year = this.getYear();
            String other$year = other.getYear();
            if (this$year == null ? other$year != null : !this$year.equals(other$year)) {
                return false;
            }
            String this$month = this.getMonth();
            String other$month = other.getMonth();
            if (this$month == null ? other$month != null : !this$month.equals(other$month)) {
                return false;
            }
            String this$day = this.getDay();
            String other$day = other.getDay();
            if (this$day == null ? other$day != null : !this$day.equals(other$day)) {
                return false;
            }
            String this$certificateno = this.getCertificateno();
            String other$certificateno = other.getCertificateno();
            if (this$certificateno == null ? other$certificateno != null : !this$certificateno.equals(other$certificateno)) {
                return false;
            }
            String this$certificatefrom = this.getCertificatefrom();
            String other$certificatefrom = other.getCertificatefrom();
            if (this$certificatefrom == null ? other$certificatefrom != null : !this$certificatefrom.equals(other$certificatefrom)) {
                return false;
            }
            String this$isSignature = this.getIsSignature();
            String other$isSignature = other.getIsSignature();
            if (this$isSignature == null ? other$isSignature != null : !this$isSignature.equals(other$isSignature)) {
                return false;
            }
            String this$fzDate = this.getFzDate();
            String other$fzDate = other.getFzDate();
            if (this$fzDate == null ? other$fzDate != null : !this$fzDate.equals(other$fzDate)) {
                return false;
            }
            String this$zYear = this.getZYear();
            String other$zYear = other.getZYear();
            if (this$zYear == null ? other$zYear != null : !this$zYear.equals(other$zYear)) {
                return false;
            }
            String this$zMonth = this.getZMonth();
            String other$zMonth = other.getZMonth();
            if (this$zMonth == null ? other$zMonth != null : !this$zMonth.equals(other$zMonth)) {
                return false;
            }
            String this$zDay = this.getZDay();
            String other$zDay = other.getZDay();
            if (this$zDay == null ? other$zDay != null : !this$zDay.equals(other$zDay)) {
                return false;
            }
            String this$signatureImg = this.getSignatureImg();
            String other$signatureImg = other.getSignatureImg();
            if (this$signatureImg == null ? other$signatureImg != null : !this$signatureImg.equals(other$signatureImg)) {
                return false;
            }
            String this$unSignaturePDF = this.getUnSignaturePDF();
            String other$unSignaturePDF = other.getUnSignaturePDF();
            if (this$unSignaturePDF == null ? other$unSignaturePDF != null : !this$unSignaturePDF.equals(other$unSignaturePDF)) {
                return false;
            }
            String this$signaturePDF = this.getSignaturePDF();
            String other$signaturePDF = other.getSignaturePDF();
            return !(this$signaturePDF == null ? other$signaturePDF != null : !this$signaturePDF.equals(other$signaturePDF));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SignatureData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $headphoto = this.getHeadphoto();
            result = result * 59 + ($headphoto == null ? 43 : $headphoto.hashCode());
            String $idcardno = this.getIdcardno();
            result = result * 59 + ($idcardno == null ? 43 : $idcardno.hashCode());
            String $year = this.getYear();
            result = result * 59 + ($year == null ? 43 : $year.hashCode());
            String $month = this.getMonth();
            result = result * 59 + ($month == null ? 43 : $month.hashCode());
            String $day = this.getDay();
            result = result * 59 + ($day == null ? 43 : $day.hashCode());
            String $certificateno = this.getCertificateno();
            result = result * 59 + ($certificateno == null ? 43 : $certificateno.hashCode());
            String $certificatefrom = this.getCertificatefrom();
            result = result * 59 + ($certificatefrom == null ? 43 : $certificatefrom.hashCode());
            String $isSignature = this.getIsSignature();
            result = result * 59 + ($isSignature == null ? 43 : $isSignature.hashCode());
            String $fzDate = this.getFzDate();
            result = result * 59 + ($fzDate == null ? 43 : $fzDate.hashCode());
            String $zYear = this.getZYear();
            result = result * 59 + ($zYear == null ? 43 : $zYear.hashCode());
            String $zMonth = this.getZMonth();
            result = result * 59 + ($zMonth == null ? 43 : $zMonth.hashCode());
            String $zDay = this.getZDay();
            result = result * 59 + ($zDay == null ? 43 : $zDay.hashCode());
            String $signatureImg = this.getSignatureImg();
            result = result * 59 + ($signatureImg == null ? 43 : $signatureImg.hashCode());
            String $unSignaturePDF = this.getUnSignaturePDF();
            result = result * 59 + ($unSignaturePDF == null ? 43 : $unSignaturePDF.hashCode());
            String $signaturePDF = this.getSignaturePDF();
            result = result * 59 + ($signaturePDF == null ? 43 : $signaturePDF.hashCode());
            return result;
        }

        public String toString() {
            return "HuNanInSignatureToPDFCompare.SignatureData(name=" + this.getName() + ", address=" + this.getAddress() + ", headphoto=" + this.getHeadphoto() + ", idcardno=" + this.getIdcardno() + ", year=" + this.getYear() + ", month=" + this.getMonth() + ", day=" + this.getDay() + ", certificateno=" + this.getCertificateno() + ", certificatefrom=" + this.getCertificatefrom() + ", isSignature=" + this.getIsSignature() + ", fzDate=" + this.getFzDate() + ", zYear=" + this.getZYear() + ", zMonth=" + this.getZMonth() + ", zDay=" + this.getZDay() + ", signatureImg=" + this.getSignatureImg() + ", unSignaturePDF=" + this.getUnSignaturePDF() + ", signaturePDF=" + this.getSignaturePDF() + ")";
        }
    }
}

