/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.impls;

import com.bcxin.tenant.open.document.domains.documents.OrgPurseDocument;
import com.bcxin.tenant.open.document.domains.repositories.OrgPurseDocumentRepository;
import com.bcxin.tenant.open.domains.entities.OrgPurseEntity;
import com.bcxin.tenant.open.domains.repositories.OrgPurseRepository;
import com.bcxin.tenant.open.domains.services.OrgPurseService;
import com.bcxin.tenant.open.domains.services.commands.RefreshOrgPurseCacheCommand;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrgPurseServiceImpl
implements OrgPurseService {
    private static final Logger logger = LoggerFactory.getLogger(OrgPurseServiceImpl.class);
    private final OrgPurseRepository orgPurseRepository;
    private final OrgPurseDocumentRepository orgPurseDocumentRepository;

    public OrgPurseServiceImpl(OrgPurseRepository orgPurseRepository, OrgPurseDocumentRepository orgPurseDocumentRepository) {
        this.orgPurseRepository = orgPurseRepository;
        this.orgPurseDocumentRepository = orgPurseDocumentRepository;
    }

    @Override
    public Collection<OrgPurseDocument> dispatch(RefreshOrgPurseCacheCommand command) {
        Collection<OrgPurseEntity> orgPurses = this.orgPurseRepository.getByOrganizationIds(command.getOrganizationIds());
        if (!CollectionUtils.isEmpty(orgPurses)) {
            Collection translateDocuments = orgPurses.stream().map(ii -> OrgPurseDocument.create((String)ii.getOrganizationId(), (long)ii.getPoints(), (boolean)ii.IsDispatchable(), (boolean)command.isFromAutoDetect())).collect(Collectors.toList());
            try {
                if (!CollectionUtils.isEmpty((Collection)translateDocuments)) {
                    this.orgPurseDocumentRepository.saveAll((Iterable)translateDocuments);
                } else {
                    translateDocuments = command.getOrganizationIds().stream().filter(ii -> StringUtil.isEmpty((String)ii)).distinct().map(ii -> OrgPurseDocument.create((String)ii, (long)0L, (boolean)false, (boolean)command.isFromAutoDetect())).collect(Collectors.toList());
                    this.orgPurseDocumentRepository.saveAll((Iterable)translateDocuments);
                }
            }
            catch (Exception ex) {
                logger.error("\u9a8c\u8bc1\u4f01\u4e1a\u8054\u52a8\u503c({})\u4fe1\u606f\u53d1\u751f\u5f02\u5e38", command.getOrganizationIds());
            }
            return translateDocuments;
        }
        return Collections.EMPTY_LIST;
    }
}

