/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.dtos;

import com.bcxin.tenant.open.document.domains.documents.RdCompanyDocument;
import com.bcxin.tenant.open.document.domains.documents.RdCompanyDocument$;
import com.bcxin.tenant.open.domains.BillPaymentRuleConfig;
import com.bcxin.tenant.open.domains.entities.OrgPurseTransactionEntity;
import com.bcxin.tenant.open.domains.entities.RoomUserEntity;
import com.bcxin.tenant.open.domains.utils.TencentConstants;
import com.bcxin.tenant.open.domains.views.TencentCallbackLogView;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchReasonType;
import com.bcxin.tenant.open.infrastructures.enums.PointChangeType;
import com.bcxin.tenant.open.infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.NotSupportTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.RetryableTenantException;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RoomCommunicatedGroupDTO {
    private static final Logger logger = LoggerFactory.getLogger(RoomCommunicatedGroupDTO.class);
    private final Long logId;
    private final DeskType deskType;
    private final String roomId;
    private final Long eventType;
    private final String callerDevicePkId;
    private final String callerDeviceNo;
    private final String callerEmployeeId;
    private final String callerEmployeeName;
    private final String callerCompanyName;
    private final boolean callerPayTheBill;
    private final String callerCompanyId;
    private final String callerOrgInstitutional;
    private final Long beginEventMsTs;
    private final Long endEventMsTs;
    private final DispatchReasonType referenceType;
    private final String referenceNumber;
    private Collection<JoinRoomUserDto> joinRoomUsers;
    private Collection<AudioVideoLogDto> audioVideoLogs;
    private Collection<NoAnswerRoomUserRecordDto> noAnswerRoomUsers;

    public Timestamp getBeginTime() {
        Date bt = new Date(this.getBeginEventMsTs());
        return Timestamp.from(bt.toInstant());
    }

    public Timestamp getEndTime() {
        Date et = new Date(this.getEndEventMsTs());
        return Timestamp.from(et.toInstant());
    }

    public CommunicatedType getCommunicatedType() {
        if (CollectionUtils.isEmpty(this.getAudioVideoLogs())) {
            return CommunicatedType.Audio;
        }
        return this.getAudioVideoLogs().stream().filter(ii -> ii.getCommunicatedType() == CommunicatedType.Video).map(ii -> ii.getCommunicatedType()).findFirst().orElse(CommunicatedType.Audio);
    }

    public RoomCommunicatedGroupDTO(DeskType deskType, Long logId, Long eventType, String roomId, String callerDevicePkId, String callerDeviceNo, String callerEmployeeId, String callerEmployeeName, String callerCompanyId, String callerCompanyName, Long beginEventMsTs, Long endEventMsTs, DispatchReasonType referenceType, String referenceNumber, boolean callerPayTheBill, String callerOrgInstitutional) {
        this.eventType = eventType;
        this.deskType = deskType;
        this.logId = logId;
        this.roomId = roomId;
        this.callerDeviceNo = callerDeviceNo;
        this.callerEmployeeId = callerEmployeeId;
        this.callerEmployeeName = callerEmployeeName;
        this.callerCompanyId = callerCompanyId;
        this.beginEventMsTs = beginEventMsTs;
        this.endEventMsTs = endEventMsTs;
        this.callerCompanyName = callerCompanyName;
        this.callerDevicePkId = callerDevicePkId;
        this.referenceType = referenceType;
        this.referenceNumber = referenceNumber;
        this.noAnswerRoomUsers = new ArrayList<NoAnswerRoomUserRecordDto>();
        this.callerPayTheBill = callerPayTheBill;
        this.callerOrgInstitutional = callerOrgInstitutional;
    }

    public static RoomCommunicatedGroupDTO create(JsonProvider jsonProvider, DeskType deskType, String roomId, DispatchReasonType referenceType, String referenceNumber, Collection<TencentCallbackLogView> roomLifeCycleLogs, Collection<RoomUserEntity> roomUsers, EntityStream entityStream, BillPaymentRuleConfig billPaymentRuleConfig) {
        Optional<TencentCallbackLogView> startRoomOptional = roomLifeCycleLogs.stream().filter(ii -> ii.getRoomId().equalsIgnoreCase(roomId) && TencentConstants.filterStartRoom(ii.getEventType())).findFirst();
        Optional<TencentCallbackLogView> endRoomOptional = roomLifeCycleLogs.stream().filter(ii -> ii.getRoomId().equalsIgnoreCase(roomId) && TencentConstants.filterEndRoom(ii.getEventType())).findFirst();
        if (!startRoomOptional.isPresent() || !endRoomOptional.isPresent()) {
            throw new RetryableTenantException("\u8be5\u623f\u95f4\u6570\u636e\u6682\u65f6\u4e0d\u5b8c\u6574, \u8bf7\u7a0d\u7b49\u540e\u518d\u91cd\u8bd5;");
        }
        TencentCallbackLogView startRoom = startRoomOptional.get();
        TencentCallbackLogView endRoom = endRoomOptional.get();
        RoomUserEntity roomUser = roomUsers.stream().filter(ii -> org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)ii.getTencentUserId(), (CharSequence)startRoom.getTencentUserId())).findFirst().orElse(null);
        if (roomUser == null) {
            throw new BadTenantException(String.format("\u975e\u9884\u671f\u5f02\u5e38: \u627e\u4e0d\u5230\u8be5\u7528\u6237(%s)\u4fe1\u606f", startRoom.getTencentUserId()));
        }
        SearchStream companyDocumentSearchStream = entityStream.of(RdCompanyDocument.class);
        RdCompanyDocument callerCompanyDocument = companyDocumentSearchStream.filter((SearchFieldPredicate)RdCompanyDocument$.ID.eq((Object)roomUser.getOrganizationId())).findFirst().orElse(null);
        if (callerCompanyDocument == null) {
            throw new ArgumentTenantException(String.format("\u5f02\u5e38\u6570\u636e: \u627e\u4e0d\u5230\u8c03\u5ea6\u65b9(%s)\u7684\u4f01\u4e1a\u4fe1\u606f\u6570\u636e", roomUser.getOrganizationId()));
        }
        boolean callerPayTheBill = billPaymentRuleConfig.isPaymentOwner(callerCompanyDocument.getInstitutional(), callerCompanyDocument.getSuperviseRegionCode());
        RoomCommunicatedGroupDTO roomCommunicatedGroup = new RoomCommunicatedGroupDTO(deskType, startRoom.getId(), startRoom.getEventType(), startRoom.getRoomId(), startRoom.getRoomId(), startRoom.getTencentUserId(), roomUser.getEmployeeId(), roomUser.getEmployeeName(), roomUser.getOrganizationId(), roomUser.getOrganizationName(), startRoom.getEventMsTs(jsonProvider), endRoom.getEventMsTs(jsonProvider), referenceType, referenceNumber, callerPayTheBill, callerCompanyDocument.getInstitutional());
        return roomCommunicatedGroup;
    }

    public void joinRooms(TencentCallbackLogView startRoomView, Collection<TencentCallbackLogView> joinRoomLogs, JsonProvider jsonProvider, Collection<RoomUserEntity> roomUsers) {
        if (CollectionUtils.isEmpty(joinRoomLogs)) {
            return;
        }
        Collection joinUserIds = joinRoomLogs.stream().filter(ix -> StringUtils.hasLength((String)ix.getTencentUserId())).map(ix -> ix.getTencentUserId()).distinct().collect(Collectors.toList());
        Collection joinRoomUsers = joinUserIds.stream().flatMap(ii -> {
            ArrayList<JoinRoomUserDto> joinUsers = new ArrayList<JoinRoomUserDto>();
            Collection enterRoomLogList = joinRoomLogs.stream().filter(ix -> TencentConstants.filterEnterRoom(ix.getEventType()) && ix.getTencentUserId().equalsIgnoreCase((String)ii)).collect(Collectors.toList());
            for (TencentCallbackLogView enterRoomLog : enterRoomLogList) {
                Optional<TencentCallbackLogView> exitRoomLogOptional = joinRoomLogs.stream().filter(ix -> TencentConstants.filterExitRoom(ix.getEventType()) && ix.getTencentUserId().equalsIgnoreCase(enterRoomLog.getTencentUserId()) && ix.getEventMsTs(jsonProvider).compareTo(enterRoomLog.getEventMsTs(jsonProvider)) > 0).findFirst();
                if (!exitRoomLogOptional.isPresent()) {
                    throw new RetryableTenantException("\u672a\u627e\u5230\u8be5\u7528\u6237\u4fe1\u606f");
                }
                TencentCallbackLogView exitRoomLog = exitRoomLogOptional.get();
                Collection matchRoomUsers = roomUsers.stream().filter(ic -> {
                    boolean flag = org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)ic.getTencentUserId(), (CharSequence)enterRoomLog.getTencentUserId());
                    if (flag) {
                        long eventMsTs = enterRoomLog.getEventMsTs(jsonProvider);
                        Date eventDate = new Date(eventMsTs);
                        flag = ic.getCreatedTime().before(eventDate);
                    }
                    return flag;
                }).sorted(Comparator.comparing(RoomUserEntity::getCreatedTime).reversed()).collect(Collectors.toList());
                RoomUserEntity selectedRoomUser = matchRoomUsers.stream().findFirst().orElse(null);
                if (selectedRoomUser == null) {
                    selectedRoomUser = roomUsers.stream().filter(ic -> {
                        boolean flag = org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)ic.getTencentUserId(), (CharSequence)enterRoomLog.getTencentUserId());
                        return flag;
                    }).sorted(Comparator.comparing(RoomUserEntity::getCreatedTime).reversed()).findFirst().orElse(null);
                }
                if (selectedRoomUser == null) {
                    throw new BadTenantException(String.format("\u975e\u9884\u671f\u6570\u636e, \u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9080\u8bf7\u8bb0\u5f55\u4fe1\u606fv2", new Object[0]));
                }
                JoinRoomUserDto joinRoomUserDto = JoinRoomUserDto.create(selectedRoomUser.getId(), enterRoomLog.getTencentUserId(), selectedRoomUser.getEmployeeId(), selectedRoomUser.getEmployeeName(), selectedRoomUser.getOrganizationName(), enterRoomLog.getEventMsTs(jsonProvider), exitRoomLog.getEventMsTs(jsonProvider), selectedRoomUser.getOrganizationId(), enterRoomLog.getTencentUserId().equalsIgnoreCase(startRoomView.getTencentUserId()), selectedRoomUser.isSuperviseRole(), selectedRoomUser.getCreatedTime(), selectedRoomUser.getSecurityStationId(), selectedRoomUser.getSecurityStationName(), selectedRoomUser.getProjectId(), selectedRoomUser.getProjectName());
                joinUsers.add(joinRoomUserDto);
            }
            return joinUsers.stream();
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(this.getJoinRoomUsers())) {
            this.setJoinRoomUsers(joinRoomUsers);
        } else {
            Collection<JoinRoomUserDto> existsJoinRoomUsers = this.getJoinRoomUsers();
            existsJoinRoomUsers.addAll(joinRoomUsers);
            this.setJoinRoomUsers(existsJoinRoomUsers);
        }
    }

    public void addAudioVideoLogs(Collection<TencentCallbackLogView> audioVideos, JsonProvider jsonProvider) {
        if (CollectionUtils.isEmpty(audioVideos)) {
            return;
        }
        ArrayList<AudioVideoLogDto> audioVideoLogs = new ArrayList<AudioVideoLogDto>();
        Collection startVideoAutoAssitLogs = audioVideos.stream().filter(ix -> TencentConstants.filterStartVideoAudioAssit(ix.getEventType())).collect(Collectors.toList());
        for (TencentCallbackLogView startCommunicated : startVideoAutoAssitLogs) {
            Optional<TencentCallbackLogView> endCommunicatedOptional = audioVideos.stream().filter(adv -> TencentConstants.filterMatchedStopVideoAudioAssit(startCommunicated.getEventType(), adv.getEventType()) && adv.getEventMsTs(jsonProvider) >= startCommunicated.getEventMsTs(jsonProvider) && adv.getTencentUserId().equals(startCommunicated.getTencentUserId())).sorted((i1, i2) -> i2.getEventMsTs(jsonProvider).compareTo(i1.getEventMsTs(jsonProvider))).findFirst();
            Long endTime = this.getEndEventMsTs();
            if (endCommunicatedOptional.isPresent()) {
                endTime = endCommunicatedOptional.get().getEventMsTs(jsonProvider);
            }
            AudioVideoLogDto audioVideoLog = AudioVideoLogDto.create(startCommunicated.getId(), startCommunicated.getEventType(), startCommunicated.getEventMsTs(jsonProvider), endTime, startCommunicated.getTencentUserId());
            audioVideoLogs.add(audioVideoLog);
        }
        Collection<AudioVideoLogDto> existsAudioVideoLogs = this.getAudioVideoLogs();
        if (existsAudioVideoLogs == null) {
            existsAudioVideoLogs = new ArrayList<AudioVideoLogDto>();
        }
        existsAudioVideoLogs.addAll(audioVideoLogs);
        if (CollectionUtils.isEmpty(existsAudioVideoLogs)) {
            return;
        }
        CommunicatedType communicatedType = CommunicatedType.Video;
        Optional<AudioVideoLogDto> selectedVideoLogOptional = existsAudioVideoLogs.stream().filter(ix -> ix.getCommunicatedType() == CommunicatedType.Video).min(Comparator.comparingLong(AudioVideoLogDto::getBeginEventMsTs));
        if (!selectedVideoLogOptional.isPresent()) {
            selectedVideoLogOptional = existsAudioVideoLogs.stream().min(Comparator.comparingLong(AudioVideoLogDto::getBeginEventMsTs));
            communicatedType = CommunicatedType.Audio;
        }
        Long endEventMsTs = existsAudioVideoLogs.stream().map(ix -> ix.getEndEventMsTs()).max(Comparator.comparingLong(Long::longValue)).get();
        AudioVideoLogDto selectedVideoLog = selectedVideoLogOptional.get();
        AudioVideoLogDto computedAudioVideoLog = AudioVideoLogDto.createByComputed(selectedVideoLog.getId(), communicatedType, selectedVideoLog.getBeginEventMsTs(), endEventMsTs, selectedVideoLog.deviceNo);
        this.setAudioVideoLogs(Collections.singleton(computedAudioVideoLog));
    }

    @Deprecated
    public void checkAndAddNotAnswerRoomUserRecords(IdWorker idWorker, String selectedTencentUserId, Collection<RoomUserEntity> userRecords) {
        Collection selectedJoinRoomUsers = this.getJoinRoomUsers().stream().filter(ii -> ii.getDeviceNo().equalsIgnoreCase(selectedTencentUserId)).sorted(Comparator.comparing(JoinRoomUserDto::getBeginTime)).collect(Collectors.toList());
        Timestamp lastAnsweredBeginTime = null;
        if (selectedJoinRoomUsers.size() < userRecords.size()) {
            for (JoinRoomUserDto joinUser : selectedJoinRoomUsers) {
                RoomUserEntity closedRoomUser;
                Timestamp selectedLastBeginTime = lastAnsweredBeginTime;
                Collection matchedRoomUsers = userRecords.stream().filter(ii -> ii.getTencentUserId().equalsIgnoreCase(joinUser.getDeviceNo()) && (selectedLastBeginTime == null || ii.getCreatedTime().after(selectedLastBeginTime)) && ii.getCreatedTime().before(ii.getCreatedTime())).sorted(Comparator.comparing(RoomUserEntity::getCreatedTime).reversed()).collect(Collectors.toList());
                if (matchedRoomUsers.size() > 1 && (closedRoomUser = (RoomUserEntity)matchedRoomUsers.stream().findFirst().orElse(null)) != null) {
                    Collection noAnswerRoomUserRecords = matchedRoomUsers.stream().filter(ii -> ii.getId() != closedRoomUser.getId()).map(ii -> NoAnswerRoomUserRecordDto.create(ii.getId(), ii.getRoomId(), ii.getTencentUserId(), ii.getEmployeeId(), ii.getEmployeeName(), ii.getOrganizationName(), ii.getOrganizationId(), ii.getCreatedTime(), ii.getSecurityStationId(), ii.getSecurityStationName(), ii.getProjectId(), ii.getProjectName())).collect(Collectors.toList());
                    this.noAnswerRoomUsers.addAll(noAnswerRoomUserRecords);
                }
                lastAnsweredBeginTime = joinUser.getBeginTime();
            }
            if (lastAnsweredBeginTime != null) {
                Collection noAnswerRoomUserRecords = userRecords.stream().map(ii -> NoAnswerRoomUserRecordDto.create(ii.getId(), ii.getRoomId(), ii.getTencentUserId(), ii.getEmployeeId(), ii.getEmployeeName(), ii.getOrganizationName(), ii.getOrganizationId(), ii.getCreatedTime(), ii.getSecurityStationId(), ii.getSecurityStationName(), ii.getProjectId(), ii.getProjectName())).collect(Collectors.toList());
                this.noAnswerRoomUsers.addAll(noAnswerRoomUserRecords);
            }
        }
    }

    public void addNoAnswerRoomUsers(IdWorker idWorker, Collection<RoomUserEntity> noAnsweredRoomUsers) {
        if (CollectionUtils.isEmpty(noAnsweredRoomUsers)) {
            return;
        }
        Collection noAnswerRoomUserRecords = noAnsweredRoomUsers.stream().map(ii -> NoAnswerRoomUserRecordDto.create(ii.getId(), ii.getId(), ii.getTencentUserId(), ii.getEmployeeId(), ii.getEmployeeName(), ii.getOrganizationName(), ii.getOrganizationId(), ii.getCreatedTime(), ii.getSecurityStationId(), ii.getSecurityStationName(), ii.getProjectId(), ii.getProjectName())).collect(Collectors.toList());
        if (this.getNoAnswerRoomUsers() == null) {
            this.setNoAnswerRoomUsers(new ArrayList<NoAnswerRoomUserRecordDto>());
        }
        this.noAnswerRoomUsers.addAll(noAnswerRoomUserRecords);
    }

    public Collection<OrgPurseTransactionEntity> translate2Transactions() {
        return null;
    }

    public Long getLogId() {
        return this.logId;
    }

    public DeskType getDeskType() {
        return this.deskType;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public Long getEventType() {
        return this.eventType;
    }

    public String getCallerDevicePkId() {
        return this.callerDevicePkId;
    }

    public String getCallerDeviceNo() {
        return this.callerDeviceNo;
    }

    public String getCallerEmployeeId() {
        return this.callerEmployeeId;
    }

    public String getCallerEmployeeName() {
        return this.callerEmployeeName;
    }

    public String getCallerCompanyName() {
        return this.callerCompanyName;
    }

    public boolean isCallerPayTheBill() {
        return this.callerPayTheBill;
    }

    public String getCallerCompanyId() {
        return this.callerCompanyId;
    }

    public String getCallerOrgInstitutional() {
        return this.callerOrgInstitutional;
    }

    public Long getBeginEventMsTs() {
        return this.beginEventMsTs;
    }

    public Long getEndEventMsTs() {
        return this.endEventMsTs;
    }

    public DispatchReasonType getReferenceType() {
        return this.referenceType;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public Collection<JoinRoomUserDto> getJoinRoomUsers() {
        return this.joinRoomUsers;
    }

    public Collection<AudioVideoLogDto> getAudioVideoLogs() {
        return this.audioVideoLogs;
    }

    public Collection<NoAnswerRoomUserRecordDto> getNoAnswerRoomUsers() {
        return this.noAnswerRoomUsers;
    }

    public void setJoinRoomUsers(Collection<JoinRoomUserDto> joinRoomUsers) {
        this.joinRoomUsers = joinRoomUsers;
    }

    public void setAudioVideoLogs(Collection<AudioVideoLogDto> audioVideoLogs) {
        this.audioVideoLogs = audioVideoLogs;
    }

    public void setNoAnswerRoomUsers(Collection<NoAnswerRoomUserRecordDto> noAnswerRoomUsers) {
        this.noAnswerRoomUsers = noAnswerRoomUsers;
    }

    public static class AudioVideoLogDto {
        private final Long id;
        private final CommunicatedType communicatedType;
        private final Long beginEventMsTs;
        private final Long endEventMsTs;
        private final String deviceNo;

        public Timestamp getBeginTime() {
            Date bt = new Date(this.getBeginEventMsTs());
            return Timestamp.from(bt.toInstant());
        }

        public Timestamp getEndTime() {
            Date et = new Date(this.getEndEventMsTs());
            return Timestamp.from(et.toInstant());
        }

        public Timestamp getActuallyBeginJoinTime(JoinRoomUserDto roomUserDto) {
            assert (roomUserDto != null);
            if (roomUserDto.getBeginEventMsTs() > this.getBeginEventMsTs()) {
                return roomUserDto.getBeginTime();
            }
            return this.getBeginTime();
        }

        public Timestamp getActuallyEndJoinTime(JoinRoomUserDto roomUserDto) {
            assert (roomUserDto != null);
            if (roomUserDto.getEndEventMsTs() == null || roomUserDto.getEndEventMsTs() > this.getEndEventMsTs()) {
                return this.getEndTime();
            }
            return roomUserDto.getEndTime();
        }

        public boolean HasJoin(JoinRoomUserDto roomUserDto) {
            assert (roomUserDto != null);
            return roomUserDto.getBeginEventMsTs() <= this.getEndEventMsTs() || this.getEndEventMsTs() == null || roomUserDto.getEndEventMsTs() == null || roomUserDto.getEndEventMsTs() > this.getBeginEventMsTs();
        }

        public AudioVideoLogDto(Long id, CommunicatedType communicatedType, Long beginEventMsTs, Long endEventMsTs, String deviceNo) {
            this.id = id;
            this.communicatedType = communicatedType;
            this.beginEventMsTs = beginEventMsTs;
            this.endEventMsTs = endEventMsTs;
            this.deviceNo = deviceNo;
        }

        public static AudioVideoLogDto create(Long id, Long eventType, Long beginEventMsTs, Long endEventMsTs, String deviceNo) {
            CommunicatedType communicatedType = CommunicatedType.Video;
            if (203L == eventType) {
                communicatedType = CommunicatedType.Audio;
            } else if (201L == eventType) {
                communicatedType = CommunicatedType.Video;
            } else {
                throw new NotSupportTenantException("\u4e0d\u652f\u6301");
            }
            return new AudioVideoLogDto(id, communicatedType, beginEventMsTs, endEventMsTs, deviceNo);
        }

        public static AudioVideoLogDto createByComputed(Long id, CommunicatedType communicatedType, Long beginEventMsTs, Long endEventMsTs, String deviceNo) {
            return new AudioVideoLogDto(id, communicatedType, beginEventMsTs, endEventMsTs, deviceNo);
        }

        public PointChangeType getChangeType() {
            switch (this.getCommunicatedType()) {
                case Audio: {
                    return PointChangeType.AudioCost;
                }
                case Video: {
                    return PointChangeType.VideoCost;
                }
            }
            throw new NotSupportTenantException(String.format("\u975e\u6cd5\u6c9f\u901a\u65b9\u5f0f:%s", this.getCommunicatedType()));
        }

        public Long getId() {
            return this.id;
        }

        public CommunicatedType getCommunicatedType() {
            return this.communicatedType;
        }

        public Long getBeginEventMsTs() {
            return this.beginEventMsTs;
        }

        public Long getEndEventMsTs() {
            return this.endEventMsTs;
        }

        public String getDeviceNo() {
            return this.deviceNo;
        }
    }

    public static class JoinRoomUserDto {
        private final long invitedUserRecordId;
        private final String id;
        private final String deviceNo;
        private final String employeeId;
        private final String employeeName;
        private final String companyName;
        private final Long beginEventMsTs;
        private final Long endEventMsTs;
        private final String domainId;
        private final boolean isCaller;
        private final boolean isSuperviseRole;
        private final Timestamp createdTime;
        private final String securityStationId;
        private final String securityStationName;
        private final String projectId;
        private final String projectName;

        public Timestamp getBeginTime() {
            Date bt = new Date(this.getBeginEventMsTs());
            return Timestamp.from(bt.toInstant());
        }

        public Timestamp getEndTime() {
            Date et = new Date(this.getEndEventMsTs());
            return Timestamp.from(et.toInstant());
        }

        public JoinRoomUserDto(long invitedUserRecordId, String deviceNo, String employeeId, String employeeName, String companyName, Long beginEventMsTs, Long endEventMsTs, String domainId, boolean isCaller, boolean isSuperviseRole, Timestamp createdTime, String securityStationId, String securityStationName, String projectId, String projectName) {
            this.deviceNo = deviceNo;
            this.employeeId = employeeId;
            this.employeeName = employeeName;
            this.beginEventMsTs = beginEventMsTs;
            this.endEventMsTs = endEventMsTs;
            this.domainId = domainId;
            this.isCaller = isCaller;
            this.securityStationId = securityStationId;
            this.securityStationName = securityStationName;
            this.projectId = projectId;
            this.projectName = projectName;
            this.id = UUID.randomUUID().toString();
            this.companyName = companyName;
            this.isSuperviseRole = isSuperviseRole;
            this.invitedUserRecordId = invitedUserRecordId;
            this.createdTime = createdTime;
        }

        public static JoinRoomUserDto create(long invitedUserRecordId, String deviceNo, String employeeId, String employeeName, String companyName, Long beginEventMsTs, Long endEventMsTs, String domainId, boolean isCaller, boolean isSuperviseRole, Timestamp createdTime, String securityStationId, String securityStationName, String projectId, String projectName) {
            return new JoinRoomUserDto(invitedUserRecordId, deviceNo, employeeId, employeeName, companyName, beginEventMsTs, endEventMsTs, domainId, isCaller, isSuperviseRole, createdTime, securityStationId, securityStationName, projectId, projectName);
        }

        public long getInvitedUserRecordId() {
            return this.invitedUserRecordId;
        }

        public String getId() {
            return this.id;
        }

        public String getDeviceNo() {
            return this.deviceNo;
        }

        public String getEmployeeId() {
            return this.employeeId;
        }

        public String getEmployeeName() {
            return this.employeeName;
        }

        public String getCompanyName() {
            return this.companyName;
        }

        public Long getBeginEventMsTs() {
            return this.beginEventMsTs;
        }

        public Long getEndEventMsTs() {
            return this.endEventMsTs;
        }

        public String getDomainId() {
            return this.domainId;
        }

        public boolean isCaller() {
            return this.isCaller;
        }

        public boolean isSuperviseRole() {
            return this.isSuperviseRole;
        }

        public Timestamp getCreatedTime() {
            return this.createdTime;
        }

        public String getSecurityStationId() {
            return this.securityStationId;
        }

        public String getSecurityStationName() {
            return this.securityStationName;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getProjectName() {
            return this.projectName;
        }
    }

    public static class NoAnswerRoomUserRecordDto {
        private final long id;
        private final String deviceNo;
        private final String employeeId;
        private final String employeeName;
        private final String companyName;
        private final String domainId;
        private final Timestamp createdTime;
        private final long referenceNumber;
        private final String securityStationId;
        private final String securityStationName;
        private final String projectId;
        private final String projectName;

        public NoAnswerRoomUserRecordDto(long id, long referenceNumber, String deviceNo, String employeeId, String employeeName, String companyName, String domainId, Timestamp createdTime, String securityStationId, String securityStationName, String projectId, String projectName) {
            this.id = id;
            this.deviceNo = deviceNo;
            this.employeeId = employeeId;
            this.employeeName = employeeName;
            this.companyName = companyName;
            this.domainId = domainId;
            this.createdTime = createdTime;
            this.referenceNumber = referenceNumber;
            this.securityStationId = securityStationId;
            this.securityStationName = securityStationName;
            this.projectId = projectId;
            this.projectName = projectName;
        }

        public static NoAnswerRoomUserRecordDto create(long id, long referenceNumber, String deviceNo, String employeeId, String employeeName, String companyName, String domainId, Timestamp createdTime, String securityStationId, String securityStationName, String projectId, String projectName) {
            return new NoAnswerRoomUserRecordDto(id, referenceNumber, deviceNo, employeeId, employeeName, companyName, domainId, createdTime, securityStationId, securityStationName, projectId, projectName);
        }

        public long getId() {
            return this.id;
        }

        public String getDeviceNo() {
            return this.deviceNo;
        }

        public String getEmployeeId() {
            return this.employeeId;
        }

        public String getEmployeeName() {
            return this.employeeName;
        }

        public String getCompanyName() {
            return this.companyName;
        }

        public String getDomainId() {
            return this.domainId;
        }

        public Timestamp getCreatedTime() {
            return this.createdTime;
        }

        public long getReferenceNumber() {
            return this.referenceNumber;
        }

        public String getSecurityStationId() {
            return this.securityStationId;
        }

        public String getSecurityStationName() {
            return this.securityStationName;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getProjectName() {
            return this.projectName;
        }
    }
}

