/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.utils;

import com.bcxin.tenant.open.domains.entities.ConfigOfBillEntity;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import com.bcxin.tenant.open.infrastructures.enums.PointChangeType;
import com.bcxin.tenant.open.infrastructures.exceptions.NotSupportTenantException;
import java.sql.Timestamp;

public class PointUtils {
    public static int translate2Points(ConfigOfBillEntity config, CommunicatedType communicatedType, int minutes) {
        switch (communicatedType) {
            case Audio: {
                return PointUtils.translate2Points(config, PointChangeType.AudioCost, minutes);
            }
            case Video: {
                return PointUtils.translate2Points(config, PointChangeType.VideoCost, minutes);
            }
        }
        throw new NotSupportTenantException(String.format("\u6682\u4e0d\u652f\u6301\u8be5\u6c9f\u901a\u7c7b\u578b:%s", communicatedType));
    }

    public static int translate2Points(ConfigOfBillEntity config, PointChangeType changeType, Timestamp beginTime, Timestamp endTime) {
        int minutes = PointUtils.translate2DispatchTimeInMinutes(beginTime, endTime);
        if (endTime == null) {
            return -1;
        }
        return PointUtils.translate2Points(config, changeType, minutes);
    }

    public static int translate2DispatchTimeInMinutes(Timestamp beginTime, Timestamp endTime) {
        int minutes;
        long seconds = 0L;
        seconds = endTime == null ? 1L : (endTime.getTime() - beginTime.getTime()) / 1000L;
        if (seconds < 0L) {
            seconds = Math.abs(seconds);
        }
        if ((minutes = (int)Math.ceil((double)seconds * 1.0 / 60.0)) == 0) {
            return 1;
        }
        return minutes;
    }

    private static int translate2Points(ConfigOfBillEntity config, PointChangeType changeType, int minutes) {
        int audioValue = 2;
        int videoValue = 4;
        if (config != null) {
            audioValue = config.getAudioMinutePerson() == null ? 2 : config.getAudioMinutePerson();
            videoValue = config.getVideoMinutePerson() == null ? 4 : config.getVideoMinutePerson();
        }
        switch (changeType) {
            case AudioCost: {
                return 0 - minutes * 1 * audioValue;
            }
            case VideoCost: {
                return 0 - minutes * 1 * videoValue;
            }
        }
        throw new NotSupportTenantException(String.format("\u6682\u4e0d\u652f\u6301\u8be5\u6c9f\u901a\u7c7b\u578b:%s", changeType));
    }
}

