/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.impls;

import com.bcxin.tenant.open.document.domains.documents.RdCommunityUserDocument;
import com.bcxin.tenant.open.document.domains.documents.RdCommunityUserDocument$;
import com.bcxin.tenant.open.document.domains.documents.RdCompanyDocument;
import com.bcxin.tenant.open.document.domains.documents.RdDispatchDataScopeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument$;
import com.bcxin.tenant.open.document.domains.repositories.RdCompanyDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RdDispatchDataScopeDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RdEmployeeDocumentRepository;
import com.bcxin.tenant.open.domains.dtos.UpdateEmployeeLocationDTO;
import com.bcxin.tenant.open.domains.entities.RdEmployeeEntity;
import com.bcxin.tenant.open.domains.readers.RdCompositedReader;
import com.bcxin.tenant.open.domains.repositories.AttendanceRepository;
import com.bcxin.tenant.open.domains.repositories.RdEmployeeRepository;
import com.bcxin.tenant.open.domains.repositories.RdSecurityStationPersonRepository;
import com.bcxin.tenant.open.domains.services.RdEmployeeService;
import com.bcxin.tenant.open.domains.services.commands.BatchUpdateEmployeeLocationCommand;
import com.bcxin.tenant.open.domains.services.commands.CleanNonUsedEmployeeCommand;
import com.bcxin.tenant.open.domains.services.commands.CreateEmployeeSyncCommand;
import com.bcxin.tenant.open.domains.services.commands.CreateSyncEmployeeCommand;
import com.bcxin.tenant.open.domains.services.commands.RefreshEmployeeStationCommand;
import com.bcxin.tenant.open.domains.services.commands.UpdateLatLonCommand;
import com.bcxin.tenant.open.domains.utils.RdEmployeeEntityUtils;
import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.enums.DutySignInType;
import com.bcxin.tenant.open.infrastructures.enums.EmploymentStatus;
import com.bcxin.tenant.open.infrastructures.enums.OccupationType;
import com.bcxin.tenant.open.infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.tenant.open.infrastructures.enums.UserCheckedStatus;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.NotSupportTenantException;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RdEmployeeServiceImpl
implements RdEmployeeService {
    private final UnitWork unitWork;
    private final RdEmployeeRepository rdEmployeeRepository;
    private final RdEmployeeDocumentRepository rdEmployeeDocumentRepository;
    private final RdSecurityStationPersonRepository rdSecurityStationPersonRepository;
    private final JsonProvider jsonProvider;
    private final AttendanceRepository attendanceRepository;
    private final RdCompositedReader compositedReader;
    private final BeanFactory beanFactory;
    private final EntityStream entityStream;

    public RdEmployeeServiceImpl(UnitWork unitWork, RdEmployeeRepository rdEmployeeRepository, RdEmployeeDocumentRepository rdEmployeeDocumentRepository, RdSecurityStationPersonRepository rdSecurityStationPersonRepository, JsonProvider jsonProvider, AttendanceRepository attendanceRepository, RdCompositedReader compositedReader, BeanFactory beanFactory, EntityStream entityStream) {
        this.unitWork = unitWork;
        this.rdEmployeeRepository = rdEmployeeRepository;
        this.rdEmployeeDocumentRepository = rdEmployeeDocumentRepository;
        this.rdSecurityStationPersonRepository = rdSecurityStationPersonRepository;
        this.jsonProvider = jsonProvider;
        this.attendanceRepository = attendanceRepository;
        this.compositedReader = compositedReader;
        this.beanFactory = beanFactory;
        this.entityStream = entityStream;
    }

    @Override
    public void dispatch(UpdateLatLonCommand command) {
    }

    @Override
    public void dispatch(CreateEmployeeSyncCommand command) {
        switch (command.getSyncType()) {
            case OrgPurse: {
                throw new NotSupportTenantException(String.format("\u6682\u4e0d\u652f\u6301\u8be5\u529f\u80fd, \u901a\u8fc7\u521b\u5efa\u623f\u95f4\u7684\u65f6\u5019\u9a8c\u8bc1\u8054\u52a8\u503c\u7684\u65b9\u5f0f\u8fdb\u884c\u9a8c\u8bc1", new Object[0]));
            }
            case DeviceBound: {
                this.dispatch_deviceBound_handler((Collection)command.getData());
                break;
            }
            case DutyStatusChanged: {
                throw new NotSupportTenantException(String.format("\u5bf9\u4e8e\u5982\u6b64\u9891\u7e41\u66f4\u65b0\u7684\u64cd\u4f5c, \u6682\u65f6\u4e0d\u652f\u6301\u5b9e\u65f6\u540c\u6b65\u5230\u6570\u636e\u5e93", new Object[0]));
            }
            case SecurityStationExpired: {
                this.dispatch_securityStationExpired_handler((Collection)command.getData());
            }
        }
    }

    @Override
    public void dispatch(RefreshEmployeeStationCommand command) {
        String tranId = this.unitWork.beginTransaction();
        try {
            this.rdSecurityStationPersonRepository.refreshEmployeeStationByEmployeeIds(command.getEmployeeIds());
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
    }

    @Override
    public void dispatch(CreateSyncEmployeeCommand command) {
        String tranId = this.unitWork.beginTransaction();
        try {
            RdEmployeeDocument document;
            RdEmployeeEntity employee = (RdEmployeeEntity)((Object)this.jsonProvider.toObject(RdEmployeeEntity.class, command.getContent()));
            if (employee == null) {
                throw new BadTenantException(String.format("\u65e0\u6548\u6570\u636e\u683c\u5f0f:%s", command.getContent()));
            }
            if (employee.getStatus() == null) {
                employee.setStatus(EmploymentStatus.OnJob);
            }
            if (employee.getDutyStatus() == null) {
                employee.setDutyStatus(DutySignInType.None);
            }
            if (employee.getOccupationType() == null) {
                employee.setOccupationType(OccupationType.Normal);
            }
            if (employee.getCheckedStatus() == null) {
                employee.setCheckedStatus(UserCheckedStatus.None);
            }
            if (employee.getAuthenticatedStatus() == null) {
                employee.setAuthenticatedStatus(RealNameAuthenticatedStatus.UnAuthenticated);
            }
            Collection<RdDispatchDataScopeDocument> dataScopeDocuments = new ArrayList<RdDispatchDataScopeDocument>();
            Collection<Object> communityUserDocuments = new ArrayList<RdCommunityUserDocument>();
            ArrayList<RdCompanyDocument> proprietorCompanyDocuments = new ArrayList<RdCompanyDocument>();
            if (!"#1".equalsIgnoreCase(employee.getSecurityStationId())) {
                EntityStream entityStream = (EntityStream)this.beanFactory.getBean(EntityStream.class);
                SearchStream searchStream = entityStream.of(RdCommunityUserDocument.class);
                searchStream = searchStream.filter((SearchFieldPredicate)RdCommunityUserDocument$.TENANT_USER_ID.eq((Object)employee.getTenantUserId()));
                communityUserDocuments = (Collection)searchStream.collect(Collectors.toList());
                RdDispatchDataScopeDocument dispatchDataScopeDocument = ((RdDispatchDataScopeDocumentRepository)this.beanFactory.getBean(RdDispatchDataScopeDocumentRepository.class)).findById((Object)employee.getSecurityStationId()).orElse(null);
                if (dispatchDataScopeDocument != null) {
                    dataScopeDocuments = Collections.singleton(dispatchDataScopeDocument);
                    Set orgIds = dispatchDataScopeDocument.getScopes();
                    if (!CollectionUtils.isEmpty((Collection)orgIds)) {
                        List companyDocuments = ((RdCompanyDocumentRepository)this.beanFactory.getBean(RdCompanyDocumentRepository.class)).findAllById((Iterable)orgIds);
                        proprietorCompanyDocuments.addAll(companyDocuments);
                    }
                }
            }
            if ((document = RdEmployeeEntityUtils.toDocument(employee, false, this.rdEmployeeDocumentRepository, this.attendanceRepository, this.compositedReader, this.beanFactory, communityUserDocuments, dataScopeDocuments, proprietorCompanyDocuments)) == null) {
                throw new BadTenantException(String.format("\u804c\u5458\u6570\u636e-\u6570\u636e\u5e93\u89e3\u6790\u5f02\u5e38:id=%s;name=%s;", employee.getId(), employee.getName()));
            }
            this.rdEmployeeDocumentRepository.save((Object)document);
            if (this.rdEmployeeRepository.getByNoPkId(employee.getId()) != null) {
                this.rdEmployeeRepository.update(employee);
            } else {
                this.rdEmployeeRepository.insert(employee);
            }
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
    }

    @Override
    public int dispatch(CleanNonUsedEmployeeCommand command) {
        int affectedCount = 0;
        this.rdEmployeeDocumentRepository.deleteAllById(command.getIds());
        String tranId = this.unitWork.beginTransaction();
        try {
            affectedCount = this.rdEmployeeRepository.deleteNonUsedRecords(command.getIds());
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
        return affectedCount;
    }

    @Override
    public void dispatch(BatchUpdateEmployeeLocationCommand command) {
        String tranId = this.unitWork.beginTransaction();
        try {
            Collection locationDTOS = command.getLocations().stream().map(ii -> UpdateEmployeeLocationDTO.create(ii.getId(), ii.getSignInType(), ii.getLon(), ii.getLat(), this.jsonProvider)).collect(Collectors.toList());
            this.rdEmployeeRepository.batchUpdateLocations(locationDTOS);
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
    }

    private void dispatch_deviceBound_handler(Collection<CreateEmployeeSyncCommand.DeviceBoundChangedEventCommand> eventCommands) {
        if (CollectionUtils.isEmpty(eventCommands)) {
            return;
        }
        Collection employeeIds = eventCommands.stream().map(ii -> ii.getEmployeeId()).collect(Collectors.toList());
        Collection<RdEmployeeEntity> employees = this.rdEmployeeRepository.getByPage(employeeIds, 0, Integer.MAX_VALUE);
        this.doExecuteSync(employees, (employee, employeeDocumentOptional) -> {
            Optional<CreateEmployeeSyncCommand.DeviceBoundChangedEventCommand> selectedEventCommandOptional = eventCommands.stream().filter(ii -> ii.getEmployeeId().equals(employee.getId())).findFirst();
            if (!selectedEventCommandOptional.isPresent()) {
                throw new BadTenantException(String.format("\u4ee3\u7801\u903b\u8f91\u5f02\u5e38, \u8bf7\u6c42\u4e2d\u4e0d\u5e94\u8be5\u627e\u5230\u6307\u5b9a\u804c\u5458(%s)\u53c2\u6570", employee.getId()));
            }
            employee.changeDeviceNumber(selectedEventCommandOptional.get().getDeviceNumber());
            if (employeeDocumentOptional.isPresent()) {
                ((RdEmployeeDocument)employeeDocumentOptional.get()).changeDeviceNumber(selectedEventCommandOptional.get().getDeviceNumber());
            }
        });
    }

    private void dispatch_securityStationExpired_handler(Collection<CreateEmployeeSyncCommand.SecurityStationExpiredSyncCommand> eventCommands) {
        if (CollectionUtils.isEmpty(eventCommands)) {
            return;
        }
        String[] stationIds = (String[])eventCommands.stream().map(ii -> ii.getStationId()).collect(Collectors.toList()).toArray(String[]::new);
        Collection documents = (Collection)this.entityStream.of(RdEmployeeDocument.class).filter((SearchFieldPredicate)RdEmployeeDocument$.SECURITY_STATION_ID.in(stationIds)).collect(Collectors.toList());
        documents.forEach(document -> {
            document.setSecurityStationId(null);
            document.setSecurityStationName(null);
        });
        this.rdEmployeeDocumentRepository.saveAll((Iterable)documents);
        Collection expiredStationEmployeeIds = documents.stream().map(ii -> ii.getId()).collect(Collectors.toList());
        this.rdEmployeeRepository.resetExpiredStationIdByIds(expiredStationEmployeeIds);
    }

    private void doExecuteSync(Collection<RdEmployeeEntity> employees, ExecuteFunction<RdEmployeeEntity, RdEmployeeDocument> doConsumerAction) {
        Collection ids = employees.stream().map(ii -> ii.getId()).collect(Collectors.toList());
        List employeeDocuments = this.rdEmployeeDocumentRepository.findAllById((Iterable)ids);
        for (RdEmployeeEntity employee : employees) {
            Optional<RdEmployeeDocument> employeeDocumentOptional = employeeDocuments.stream().filter(ii -> ii.getId().equalsIgnoreCase(employee.getId())).findFirst();
            doConsumerAction.accept(employee, employeeDocumentOptional);
        }
        this.rdEmployeeDocumentRepository.saveAll((Iterable)employeeDocuments);
        this.rdEmployeeRepository.batchUpdate(employees);
    }

    public static interface ExecuteFunction<A, B> {
        public void accept(A var1, Optional<B> var2);
    }
}

