/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ContentFollowType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import org.springframework.util.StringUtils;

public class CreateTenantContentFollowCommand
extends CommandAbstract {
    private final ContentFollowType followType;
    private final String contentFollowId;
    private final String deviceNo;
    private final String followUserId;

    public CreateTenantContentFollowCommand(ContentFollowType followType, String contentFollowId, String deviceNo, String followUserId) {
        this.followType = followType;
        this.contentFollowId = contentFollowId;
        this.deviceNo = deviceNo;
        this.followUserId = followUserId;
    }

    public void validate() {
        super.validate();
        if (this.getFollowType() == null) {
            throw new BadTenantException("\u5173\u6ce8\u5185\u5bb9\u7684\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)this.getContentFollowId())) {
            throw new BadTenantException("\u5173\u6ce8\u5185\u5bb9\u7684Id(contentFollowId)\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!StringUtils.hasLength((String)this.getDeviceNo())) {
            throw new BadTenantException("\u5173\u6ce8\u4eba\u8eab\u4efd(deviceNo)\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!StringUtils.hasLength((String)this.getFollowUserId())) {
            throw new BadTenantException("\u5173\u6ce8\u4ebaId(followerId)\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    public static CreateTenantContentFollowCommand create(ContentFollowType followType, String contentFollowId, String deviceNo, String followUserId) {
        CreateTenantContentFollowCommand command = new CreateTenantContentFollowCommand(followType, contentFollowId, deviceNo, followUserId);
        return command;
    }

    public ContentFollowType getFollowType() {
        return this.followType;
    }

    public String getContentFollowId() {
        return this.contentFollowId;
    }

    public String getDeviceNo() {
        return this.deviceNo;
    }

    public String getFollowUserId() {
        return this.followUserId;
    }
}

