/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.springframework.util.CollectionUtils;

public class AttendanceCriteria
extends CriteriaAbstract {
    private final String name;
    private final String companyName;
    private final String securityStationName;
    private final Collection<String> superviseDepartIds;
    private final Date createdStarDate;
    private final Date createdEndDate;
    private final String idCardNo;
    private final boolean supervise;
    private final Collection<String> organizationIds;
    private final Collection<String> projectIds;
    private final SearchModel searchModel;
    private Collection<String> otherSpecialPermissionScopeIds;
    private Collection<String> managedProjectIds;
    private boolean hasManagedProjectIds;

    public AttendanceCriteria(String name, String companyName, String securityStationName, Collection<String> organizationIds, boolean supervise, Collection<String> superviseDepartIds, Date createdStarDate, Date createdEndDate, String idCardNo, Collection<String> projectIds, int pageIndex, int pageSize, SearchModel searchModel) {
        super(pageIndex, pageSize);
        this.name = name;
        this.companyName = companyName;
        this.securityStationName = securityStationName;
        this.superviseDepartIds = superviseDepartIds;
        this.createdStarDate = createdStarDate;
        this.createdEndDate = createdEndDate;
        this.idCardNo = idCardNo;
        this.searchModel = searchModel;
        this.supervise = supervise;
        this.organizationIds = organizationIds;
        this.projectIds = projectIds;
    }

    public void assignManagedProjectIds(Collection<String> managedProjectIds, Collection<String> otherSpecialPermissionScopeIds) {
        this.otherSpecialPermissionScopeIds = otherSpecialPermissionScopeIds;
        this.managedProjectIds = managedProjectIds;
        this.hasManagedProjectIds = !CollectionUtils.isEmpty(this.managedProjectIds);
    }

    public static AttendanceCriteria create(String name, String companyName, String securityStationName, String[] organizationIds, boolean supervise, Collection<String> superviseDepartIds, Date createdStarDate, Date createdEndDate, String idCardNo, Collection<String> projectIds, int pageIndex, int pageSize, SearchModel searchModel) {
        return new AttendanceCriteria(name, companyName, securityStationName, organizationIds == null ? Collections.EMPTY_LIST : Arrays.stream(organizationIds).toList(), supervise, superviseDepartIds, createdStarDate, createdEndDate, idCardNo, projectIds, pageIndex, pageSize, searchModel);
    }

    public String getName() {
        return this.name;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getSecurityStationName() {
        return this.securityStationName;
    }

    public Collection<String> getSuperviseDepartIds() {
        return this.superviseDepartIds;
    }

    public Date getCreatedStarDate() {
        return this.createdStarDate;
    }

    public Date getCreatedEndDate() {
        return this.createdEndDate;
    }

    public String getIdCardNo() {
        return this.idCardNo;
    }

    public boolean isSupervise() {
        return this.supervise;
    }

    public Collection<String> getOrganizationIds() {
        return this.organizationIds;
    }

    public Collection<String> getProjectIds() {
        return this.projectIds;
    }

    public SearchModel getSearchModel() {
        return this.searchModel;
    }

    public Collection<String> getOtherSpecialPermissionScopeIds() {
        return this.otherSpecialPermissionScopeIds;
    }

    public Collection<String> getManagedProjectIds() {
        return this.managedProjectIds;
    }

    public boolean isHasManagedProjectIds() {
        return this.hasManagedProjectIds;
    }

    public static enum SearchModel {
        AdvanceSearch,
        Today,
        RecentWeek,
        RecentMonth;

    }
}

