package com.bcxin.tenant.open.backend.tasks.impls;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.tenant.open.backend.tasks.properties.RtcDeviceProperty;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.jdks.DeviceWriterRpcProvider;
import com.bcxin.tenant.open.jdks.ThirdDeviceRpcProvider;
import com.bcxin.tenant.open.jdks.requests.DeviceSyncRequest;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.util.*;

@DubboService
public class ThirdDeviceRpcProviderImpl implements ThirdDeviceRpcProvider {
    private static final Logger logger = LoggerFactory.getLogger(ThirdDeviceRpcProviderImpl.class);
    private final RtcDeviceProperty deviceProperty;
    private final JsonProvider jsonProvider;
    private final CloseableHttpClient httpClient;
    private final DeviceWriterRpcProvider deviceWriterRpcProvider;

    public ThirdDeviceRpcProviderImpl(RtcDeviceProperty deviceProperty, JsonProvider jsonProvider, DeviceWriterRpcProvider deviceWriterRpcProvider) {
        this.deviceProperty = deviceProperty;
        this.jsonProvider = jsonProvider;
        this.deviceWriterRpcProvider = deviceWriterRpcProvider;
        this.httpClient = HttpClientBuilder.create().build();
    }

    @Override
    public void refresh(Collection<String> dispatchNos) {
        if(CollectionUtils.isEmpty(dispatchNos)) {
            logger.error("调度设备信息不能为空:{}", dispatchNos);
            return;
        }
        /**
         * 获取设备的uid信息
         */
        StringBuilder trace  = new StringBuilder();
        try {
            HttpPost post = new HttpPost(String.format("%s/sapi/misc/users/list", deviceProperty.getUrl()));
            post.setHeader("auth_code", deviceProperty.getAuthCode());
            post.addHeader("Content-Type", "application/json");
            Map bodyMap = new HashMap();
            bodyMap.put("adminName", deviceProperty.getAdminName());
            //Collection<String> dispatchNos = requests.stream().map(ii -> ii.getDeviceNo()).collect(Collectors.toList());
            bodyMap.put("accountList", dispatchNos);

            String body = this.jsonProvider.getJson(bodyMap);
            post.setEntity(new StringEntity(body));

            trace.append(String.format("url=%s;rq=%s;",post.getURI(),body));
            try (CloseableHttpResponse response = this.httpClient.execute(post)) {
                String bodyString = EntityUtils.toString(response.getEntity());
                JSONObject bodyJSON = this.jsonProvider.toObject(JSONObject.class, bodyString);
                JSONArray dataRecords = bodyJSON.getJSONObject("data").getJSONArray("records");
                trace.append(String.format("响应信息=%s", bodyString));


                Collection<DeviceSyncRequest> deviceSyncRequests = new ArrayList<>();
                for (int index = 0; index < dataRecords.size(); index++) {
                    JSONObject item = dataRecords.getJSONObject(index);

                    DeviceSyncRequest dr = DeviceSyncRequest.create(
                            item.getString("account"),
                            item.getString("uid")
                    );

                    deviceSyncRequests.add(dr);
                }

                this.deviceWriterRpcProvider.batchUpdate(deviceSyncRequests);
            }
        }
        catch (Exception ex) {
            logger.error("通过中诺API获取uid发生异常:{}", trace, ex);
        }
    }
}
