package com.bcxin.tenant.open.backend.tasks.configs;

import com.bcxin.tenant.open.jdks.AttendanceRpcProvider;
import com.bcxin.tenant.open.jdks.EmployeeWriterRpcProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class ScheduleConfig_Clean implements BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleConfig_Clean.class);
    private static final int SCHEDULE_PAGE_SIZE = 800;
    private BeanFactory beanFactory;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Scheduled(cron = "${scheduled.cron.cleanNonUsedData}")
    public void updateEmployeeStatus() {
        EmployeeWriterRpcProvider employeeWriterRpcProvider = this.beanFactory.getBean(EmployeeWriterRpcProvider.class);
        logger.error("begin to auto clean non-used employees");
        System.err.println("begin to auto clean non-used employees");
        int affectedCount = 0;
        int affectedIndex = 0;

        do {
            affectedCount = employeeWriterRpcProvider.clearNonUsedEmployees(SCHEDULE_PAGE_SIZE);
            //logger.error("clean non-used employees total count={}", affectedCount);

            /**
             * 加这个的目的是为了避免死循环
             */
            affectedIndex++;
        }
        while (affectedCount > 0 && affectedIndex < 1000);
    }

    @Scheduled(cron = "${scheduled.cron.cleanNonUsedData}")
    public void cleanRecentlyAttendanceRecords() {
        AttendanceRpcProvider attendanceRpcProvider = this.beanFactory.getBean(AttendanceRpcProvider.class);
        int affectedCount = 0;
        int index = 0;
        do {
            index++;
            affectedCount = attendanceRpcProvider.cleanRecentlyRecords();
        } while (affectedCount > 0 && index < 1000);
    }
}
