package com.bcxin.tenant.open.backend.tasks.configs;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.tenant.open.backend.tasks.utils.DebeziumUtil;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.constants.KafkaConstants;
import com.bcxin.tenant.open.jdks.DispatchDataScopeRpcProvider;
import com.bcxin.tenant.open.jdks.RdSyncRpcWriterProvider;
import com.bcxin.tenant.open.jdks.SecurityStationReaderRpcProvider;
import com.bcxin.tenant.open.jdks.UserWriterRpcProvider;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

@Component
public class KafkaComponent_Workstation extends KafkaComponentAbstract{
    private static final Logger logger = LoggerFactory.getLogger(KafkaComponent_Workstation.class);
    private final UserWriterRpcProvider userWriterRpcProvider;
    protected KafkaComponent_Workstation(JsonProvider jsonProvider,
                                         SecurityStationReaderRpcProvider securityStationReaderRpcProvider,
                                         DispatchDataScopeRpcProvider dispatchDataScopeRpcProvider,
                                         RdSyncRpcWriterProvider syncRpcWriterProvider, UserWriterRpcProvider userWriterRpcProvider) {
        super(jsonProvider, securityStationReaderRpcProvider, dispatchDataScopeRpcProvider, syncRpcWriterProvider);
        this.userWriterRpcProvider = userWriterRpcProvider;
    }

    /**
     * 巡防任务
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-TOPIC_DUTY_TLK_PATROL_TASKS",
            topics = {
                    KafkaConstants.TOPIC_DUTY_TLK_PATROL_TASKS
            }, groupId = "${spring.kafka.consumer.group-id}-TOPIC_DUTY_TLK_PATROL_TASKS")
    public void ackPatrolTasksListener(List<ConsumerRecord<String, String>> records,
                                        Acknowledgment ack) {
        logger.error("消费巡防任务-TOPIC_DUTY_TLK_PATROL_TASKS 主题信息:{}", records.stream().map(ii -> ii.value()).collect(Collectors.joining()));

        executeConsumeData(syncRpcWriterProvider, records, ack);
    }

    /**
     * 巡防任务相关点位
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-TOPIC_DUTY_TLK_PATROL_POINTS",
            topics = {
                    KafkaConstants.TOPIC_DUTY_TLK_PATROL_POINTS
            }, groupId = "${spring.kafka.consumer.group-id}-TOPIC_DUTY_TLK_PATROL_POINTS")
    public void ackPatrolPointsListener(List<ConsumerRecord<String, String>> records,
                                       Acknowledgment ack) {

        logger.error("巡防任务相关点位-TOPIC_DUTY_TLK_PATROL_POINTS 主题信息:{}", records.stream().map(ii -> ii.value()).collect(Collectors.joining()));

        executeConsumeData(syncRpcWriterProvider, records, ack);
    }

    /**
     * 巡防任务关联线路
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-TOPIC_DUTY_TLK_PATROL_TASK_PATH_RELATIONS",
            topics = {
                    KafkaConstants.TOPIC_DUTY_TLK_PATROL_TASK_PATH_RELATIONS
            }, groupId = "${spring.kafka.consumer.group-id}-TOPIC_DUTY_TLK_PATROL_TASK_PATH_RELATIONS")
    public void ackPatrolTaskRelationListener(List<ConsumerRecord<String, String>> records,
                                        Acknowledgment ack) {

        logger.error("巡防任务相关点位-TOPIC_DUTY_TLK_PATROL_TASK_PATH_RELATIONS 主题信息:{}", records.stream().map(ii -> ii.value()).collect(Collectors.joining()));

        executeConsumeData(syncRpcWriterProvider, records, ack);
    }

    /**
     * 巡防任务相关路线点位
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-TOPIC_DUTY_TLK_PATROL_PATH_POINT_RELATIONS",
            topics = {
                    KafkaConstants.TOPIC_DUTY_TLK_PATROL_PATH_POINT_RELATIONS
            }, groupId = "${spring.kafka.consumer.group-id}-TOPIC_DUTY_TLK_PATROL_PATH_POINT_RELATIONS")
    public void ackPatrolPointRelationsListener(List<ConsumerRecord<String, String>> records,
                                       Acknowledgment ack) {
        logger.error("巡防任务相关路线点位-TOPIC_DUTY_TLK_PATROL_PATH_POINT_RELATIONS 主题信息:{}",
                records.stream().map(ii -> ii.value()).collect(Collectors.joining()));
        executeConsumeData(syncRpcWriterProvider, records, ack);
    }


    /**
     * 任务与人员的关系
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-TOPIC_DUTY_TLK_PATROL_TASK_EMPLOYEE_RELATIONS",
            topics = {
                    KafkaConstants.TOPIC_DUTY_TLK_PATROL_TASK_EMPLOYEE_RELATIONS
            }, groupId = "${spring.kafka.consumer.group-id}-TOPIC_DUTY_TLK_PATROL_TASK_EMPLOYEE_RELATIONS")
    public void ackPatrolTaskEmployeeRelationsListener(List<ConsumerRecord<String, String>> records,
                                                Acknowledgment ack) {
        logger.error("任务与人员的关系-TOPIC_DUTY_TLK_PATROL_TASK_EMPLOYEE_RELATIONS 主题信息:{}", records.stream().map(ii -> ii.value()).collect(Collectors.joining()));

        executeConsumeData(syncRpcWriterProvider, records, ack);
    }

    /**
     * 任务与人员的关系
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-TOPIC_DUTY_TLK_PATROL_TASK_EMPLOYEE_RELATIONS_With_Points",
            topics = {
                    KafkaConstants.TOPIC_DUTY_TLK_PATROL_TASK_EMPLOYEE_RELATIONS
            }, groupId = "${spring.kafka.consumer.group-id}-TOPIC_DUTY_TLK_PATROL_TASK_EMPLOYEE_RELATIONS_With_Points")
    public void ackPatrolTaskEmployeeRelationsWithPointsListener(List<ConsumerRecord<String, String>> records,
                                                       Acknowledgment ack) {

    }
}
