package com.bcxin.tenant.open.backend.tasks.configs;

import com.bcxin.tenant.open.backend.tasks.rings.components.RingBufferProducer;
import com.bcxin.tenant.open.backend.tasks.rings.vos.RefreshOrganizationVo;
import com.bcxin.tenant.open.backend.tasks.rings.vos.RefreshProjectVo;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.constants.KafkaConstants;
import com.bcxin.tenant.open.jdks.DispatchDataScopeRpcProvider;
import com.bcxin.tenant.open.jdks.HotCacheRpcProvider;
import com.bcxin.tenant.open.jdks.RdSyncRpcWriterProvider;
import com.bcxin.tenant.open.jdks.SecurityStationReaderRpcProvider;
import com.bcxin.tenant.open.jdks.requests.HotCacheRequest;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 临保项目
 */
@Component
public class KafkaComponent_TemporaryProject extends KafkaComponentAbstract {
    private static final Logger logger = LoggerFactory.getLogger(KafkaComponent_TemporaryProject.class);
    private final RingBufferProducer ringBufferProducer;
    private final HotCacheRpcProvider hotCacheRpcProvider;

    protected KafkaComponent_TemporaryProject(
            JsonProvider jsonProvider,
            SecurityStationReaderRpcProvider securityStationReaderRpcProvider,
            DispatchDataScopeRpcProvider dispatchDataScopeRpcProvider,
            RdSyncRpcWriterProvider syncRpcWriterProvider,
            RingBufferProducer ringBufferProducer, HotCacheRpcProvider hotCacheRpcProvider) {
        super(jsonProvider, securityStationReaderRpcProvider, dispatchDataScopeRpcProvider, syncRpcWriterProvider);
        this.ringBufferProducer = ringBufferProducer;
        this.hotCacheRpcProvider = hotCacheRpcProvider;
    }

    /**
     * 临保项目
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-baibaodunflow-2-tlk_temporary_protection_project",
            topics = {
                    KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_TEMPORARY_PROTECTION_PROJECT
            }, groupId = "${spring.kafka.consumer.group-id}-baibaodunflow-2-tlk_temporary_protection_project")
    public void ackTemporaryProtectionProjectListener_TOPIC_BAIBAODUNFLOW_TLK_TEMPORARY_PROTECTION_PROJECT(
            List<ConsumerRecord<String, String>> records, Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);

        Collection<String> organizationIds =
                records.stream().flatMap(ii -> {
                    var value = extractFieldFromJson(ii.value(), "DOMAINID");
                    if (value == null) {
                        return null;
                    }
                    return value.stream();
                }).filter(ii -> ii != null).collect(Collectors.toSet());

        if (!CollectionUtils.isEmpty(organizationIds)) {
            this.ringBufferProducer.publish(RefreshOrganizationVo.create(organizationIds));
        }
    }

    /**
     * 临保项目人员
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-baibaodunflow-2-tlk_post_person",
            topics = {
                    KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_POST_PERSON
            }, groupId = "${spring.kafka.consumer.group-id}-baibaodunflow-2-tlk_post_person")
    public void ackTemporaryProtectionProjectListener_TOPIC_BAIBAODUNFLOW_TOPIC_BAIBAODUNFLOW_TLK_POST_PERSON(
            List<ConsumerRecord<String, String>> records, Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);
    }

    /**
     * 临保项目小组
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-baibaodunflow-2-tlk_temporary_protection_group",
            topics = {
                    KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_TEMPORARY_PROTECTION_GROUP
            }, groupId = "${spring.kafka.consumer.group-id}-baibaodunflow-2-tlk_temporary_protection_group")
    public void ackTemporaryProtectionProjectListener_TOPIC_BAIBAODUNFLOW_TLK_POST_GROUP(
            List<ConsumerRecord<String, String>> records, Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);

        Collection<String> projectIds =
                records.stream().flatMap(ii -> {
                    var value = extractFieldFromJson(ii.value(), "ITEM_PROJECT_ID");
                    if (value == null) {
                        return null;
                    }
                    return value.stream();
                }).filter(ii -> ii != null).collect(Collectors.toSet());

        if (!CollectionUtils.isEmpty(projectIds)) {
            this.ringBufferProducer.publish(RefreshProjectVo.create(projectIds));
        }
    }

    /**
     * 临保小组类型
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-baibaodunflow-2-tlk_project_person_type",
            topics = {
                    KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_PROJECT_PERSON_TYPE
            }, groupId = "${spring.kafka.consumer.group-id}-baibaodunflow-2-tlk_project_person_type")
    public void ackTemporaryProtectionProjectListener_TOPIC_BAIBAODUNFLOW_TLK_PROJECT_PERSON_TYPE(
            List<ConsumerRecord<String, String>> records, Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);
    }

    /**
     * 活动承办商关联的项目信息
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-baibaodunflow-2-tlk_project_join",
            topics = {
                    KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_PROJECT_JOIN
            }, groupId = "${spring.kafka.consumer.group-id}-baibaodunflow-2-tlk_project_join")
    public void ackTemporaryProtectionProjectListener_TOPIC_BAIBAODUNFLOW_TLK_PROJECT_JOIN(
            List<ConsumerRecord<String, String>> records, Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);
    }

    /**
     * 活动承办商-管理人员-管理的岗点信息
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-baibaodunflow-2-tlk_manage_post",
            topics = {
                    KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_MANAGE_POST
            }, groupId = "${spring.kafka.consumer.group-id}-baibaodunflow-2-tlk_manage_post")
    public void ackTemporaryProtectionProjectListener_TOPIC_BAIBAODUNFLOW_TLK_MANAGE_POST(
            List<ConsumerRecord<String, String>> records, Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);

        Collection<String> empIds =
                records.stream().flatMap(ii -> extractFieldFromJson("ITEM_PERSON_ID", ii.value()).stream())
                        .collect(Collectors.toList());
        this.hotCacheRpcProvider.refresh(HotCacheRequest.create(HotCacheRequest.CacheCategory.Employee, empIds));
    }

    /**
     * 活动承办商-管理人员-来源信息
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-baibaodunflow-2-tlk_project_person_source",
            topics = {
                    KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_PROJECT_PERSON_SOURCE
            }, groupId = "${spring.kafka.consumer.group-id}-baibaodunflow-2-tlk_project_person_source")
    public void ackTemporaryProtectionProjectListener_TOPIC_BAIBAODUNFLOW_TLK_PROJECT_PERSON_SOURCE(
            List<ConsumerRecord<String, String>> records, Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);

        Collection<String> ids = records.stream()
                .map(ix -> ix.key()).filter(ii -> StringUtils.hasLength(ii))
                .collect(Collectors.toList());

        this.refreshHotCache(this.hotCacheRpcProvider, HotCacheRequest.CacheCategory.DispatchDataSource, ids);
    }
}
