package com.bcxin.tenant.open.backend.tasks.configs;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.constants.KafkaConstants;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.jdks.DispatchDataScopeRpcProvider;
import com.bcxin.tenant.open.jdks.HotCacheRpcProvider;
import com.bcxin.tenant.open.jdks.RdSyncRpcWriterProvider;
import com.bcxin.tenant.open.jdks.SecurityStationReaderRpcProvider;
import com.bcxin.tenant.open.jdks.requests.HotCacheRequest;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.List;
import java.util.*;
import java.util.stream.Collectors;

@Component
public class KafkaComponent extends KafkaComponentAbstract {
    private static final Logger logger = LoggerFactory.getLogger(KafkaComponent.class);

    @Value("${spring.kafka.bootstrap-servers}")
    private String bootstrapServer;

    private final HotCacheRpcProvider hotCacheRpcProvider;

    public KafkaComponent(RdSyncRpcWriterProvider syncRpcWriterProvider,
                          JsonProvider jsonProvider,
                          DispatchDataScopeRpcProvider dispatchDataScopeRpcProvider,
                          SecurityStationReaderRpcProvider securityStationReaderRpcProvider,
                          HotCacheRpcProvider hotCacheRpcProvider) {
        super(jsonProvider, securityStationReaderRpcProvider, dispatchDataScopeRpcProvider, syncRpcWriterProvider);
        this.hotCacheRpcProvider = hotCacheRpcProvider;
    }

    /**
     * 订阅人员信息
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-tenant-2-dispatch-id-TOPIC_OBPM2_TENANT_USERS",
            topics = {
                    KafkaConstants.TOPIC_OBPM2_TENANT_USERS
            }, groupId = "${spring.kafka.consumer.group-id}-tenant-2-dispatch")
    public void ackBaibaodunflowCompanyInformationListener_TOPIC_OBPM2_TENANT_USERS(List<ConsumerRecord<String, String>> records,
                                                                                    Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);
    }

    /**
     * 订阅职员信息
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-tenant-2-dispatch-id-TOPIC_OBPM2_TENANT_EMPLOYEES",
            topics = {
                    KafkaConstants.TOPIC_OBPM2_TENANT_EMPLOYEES
            }, groupId = "${spring.kafka.consumer.group-id}-tenant-2-dispatch")

    public void ackBaibaodunflowCompanyInformationListener_TOPIC_OBPM2_TENANT_EMPLOYEES(List<ConsumerRecord<String, String>> records,
                                                                                        Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);

        Collection<String> ids = records.stream()
                .map(ix -> ix.key()).filter(ii -> StringUtils.hasLength(ii))
                .collect(Collectors.toList());

        if (!CollectionUtils.isEmpty(ids)) {
            this.refreshHotCache(this.hotCacheRpcProvider, HotCacheRequest.CacheCategory.Employee, ids);
        }
    }

    /**
     * 订阅死信信息
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-tenant-2-dispatch-id-TOPIC_DEAD_LETTER_DISPATCH",
            topics = {
                    KafkaConstants.TOPIC_DEAD_LETTER_DISPATCH
            }, groupId = "${spring.kafka.consumer.group-id}-tenant-2-dispatch")
    public void ackBaibaodunflowCompanyInformationListener_DEAD_LETTER(List<ConsumerRecord<String, String>> records,
                                                                       Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);
    }

    /**
     * 订阅组织信息
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-tenant-2-dispatch-id-TOPIC_OBPM2_TENANT_ORGANIZATIONS",
            topics = {
                    KafkaConstants.TOPIC_OBPM2_TENANT_ORGANIZATIONS
            }, groupId = "${spring.kafka.consumer.group-id}-tenant-2-dispatch")
    public void ackBaibaodunflowCompanyInformationListener_TOPIC_OBPM2_TENANT_ORGANIZATIONS(List<ConsumerRecord<String, String>> records,
                                                                                            Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);

        Collection<String> ids = records.stream()
                .map(ix -> ix.key()).filter(ii -> StringUtils.hasLength(ii))
                .collect(Collectors.toList());

        this.refreshHotCache(this.hotCacheRpcProvider, HotCacheRequest.CacheCategory.Organization, ids);
    }


    /**
     * 订阅驻勤信息
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-tenant-2-dispatch-id-TOPIC_BAIBAODUNFLOW_TLK_STATION",
            topics = {
                    KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_STATION
            }, groupId = "${spring.kafka.consumer.group-id}-tenant-2-dispatch")
    public void ackBaibaodunflowCompanyInformationListener_TOPIC_BAIBAODUNFLOW_TLK_STATION(List<ConsumerRecord<String, String>> records,
                                                                                           Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);
        Collection<String> ids = records.stream()
                .map(ix -> ix.key()).filter(ii -> StringUtils.hasLength(ii))
                .collect(Collectors.toList());
        this.refreshHotCache(this.hotCacheRpcProvider, HotCacheRequest.CacheCategory.Station, ids);
    }

    /**
     * 订阅社区警务团队
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-tenant-2-dispatch-id-TOPIC_BAIBAODUNFLOW_TLK_PT_SECURITYMAN",
            topics = {
                    KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_PT_SECURITYMAN
            }, groupId = "${spring.kafka.consumer.group-id}-tenant-2-dispatch")
    public void ackBaibaodunflowCompanyInformationListener_TOPIC_BAIBAODUNFLOW_TLK_PT_SECURITYMAN(List<ConsumerRecord<String, String>> records,
                                                                                           Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);
    }

    /**
     * 订阅社区警务团队
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-tenant-2-dispatch-id-TOPIC_OBPM2_T_SUPERVISE_DEPARTMENT",
            topics = {
                    KafkaConstants.TOPIC_OBPM2_T_SUPERVISE_DEPARTMENT
            }, groupId = "${spring.kafka.consumer.group-id}-tenant-2-dispatch")
    public void ackDepartmentLevelListener_TOPIC_ORGANIZATIONAUTH_TLK_DEPARTMENTLEVEL(List<ConsumerRecord<String, String>> records,
                                                                                                  Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);
    }

    /**
     * 内保单位关注的驻勤点信息
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-tenant-2-dispatch-id-TOPIC_BAIBAODUNFLOW_TLK_N_SECURITY",
            topics = {
                    KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_N_SECURITY
            }, groupId = "${spring.kafka.consumer.group-id}-tenant-2-dispatch")
    public void ackNSecurity_TOPIC_BAIBAODUNFLOW_TLK_N_SECURITY(List<ConsumerRecord<String, String>> records,
                                                                                      Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);
    }

     /**
     * 联动值消耗情况
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-tenant-2-dispatch-id-TOPIC_DISPATCH_TLK_ORG_PURSE",
            topics = {
                    KafkaConstants.TOPIC_DISPATCH_TLK_DEVICE,
                    KafkaConstants.TOPIC_DISPATCH_TLK_ORG_PURSE
            }, groupId = "${spring.kafka.consumer.group-id}-tenant-2-dispatch")
    public void ackBaibaodunflowCompanyInformationListener_TOPIC_DISPATCH_TLK_ORG_PURSE_DISPATCH_TLK_DEVICE(List<ConsumerRecord<String, String>> records,
                                                                                           Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);

        Collection<String> changedOrgPurseIds =
                records.stream()
                        .filter(ii -> ii.topic().equalsIgnoreCase(KafkaConstants.TOPIC_DISPATCH_TLK_ORG_PURSE))
                        .flatMap(ii -> {
                            String pointsText = extractFieldFromJson(ii.value(), "after", "ITEM_POINTS");
                            Double points = 0d;
                            try {
                                points = Double.parseDouble(pointsText);
                            } catch (Exception ex) {
                                logger.error("忽略-转化企业联动值发生异常:points={},值={}", pointsText, ii.value(), ex);
                            }

                            String beforePointsText = extractFieldFromJson(ii.value(), "before", "ITEM_POINTS");
                            Double beforePoints = 0d;
                            try {
                                beforePoints = Double.parseDouble(beforePointsText);
                            } catch (Exception ex) {
                                logger.error("忽略-转化企业联动值发生异常:beforePointsText={},值={}", beforePointsText, ii.value(), ex);
                            }

                            if (points <= 0 || (beforePoints<=0 && points>0)) {
                                Collection<String> orgIds = extractFieldFromJson(ii.value(), "ITEM_ORGANIZATION_ID");

                                if (orgIds != null) {
                                    return orgIds.stream();
                                }
                            }

                            return null;
                        }).filter(ii -> ii != null)
                        .collect(Collectors.toList());

        if (!CollectionUtils.isEmpty(changedOrgPurseIds)) {
            this.hotCacheRpcProvider.refresh(HotCacheRequest.create(HotCacheRequest.CacheCategory.Organization, changedOrgPurseIds));
            this.hotCacheRpcProvider.refresh(HotCacheRequest.create(HotCacheRequest.CacheCategory.OrgPurse, changedOrgPurseIds));
        }
    }

        /**
     * 订阅考试点
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-tenant-2-dispatch-id-TOPIC_TMS_TLK_EXAM_SITE",
            topics = {
                    KafkaConstants.TOPIC_TMS_TLK_EXAM_SITE
            }, groupId = "${spring.kafka.consumer.group-id}-tenant-2-dispatch")
    public void ackTmsExamListener_TOPIC_TMS_TLK_EXAM_SITE(List<ConsumerRecord<String, String>> records,
                                                                                           Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);
    }

    /**
    /**
     * 内保单位的信息
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-tenant-2-dispatch-id-TOPIC_DISPATCH_PROPRIETOR_COMPANY_CHANGED",
            topics = {
                    KafkaConstants.TOPIC_DISPATCH_PROPRIETOR_COMPANY_CHANGED
            }, groupId = "${spring.kafka.consumer.group-id}-tenant-2-dispatch")
    public void ackProprietorCompanyChangedInformationListener_TOPIC_DISPATCH_TLK_ORG_PURSE_DISPATCH_TLK_DEVICE(
            List<ConsumerRecord<String, String>> records, Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);
    }


        /**
     * 订阅考场
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-tenant-2-dispatch-id-TOPIC_TMS_TLK_EXAM_ROOM",
            topics = {
                    KafkaConstants.TOPIC_TMS_TLK_EXAM_ROOM
            }, groupId = "${spring.kafka.consumer.group-id}-tenant-2-dispatch")
    public void ackTmsExamListener_TOPIC_TMS_TLK_EXAM_ROOM(List<ConsumerRecord<String, String>> records,
                                                           Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);
    }

    /**
     * 订阅考试报名
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-tenant-2-dispatch-id-TOPIC_TMS_TLK_SYSTEM_EXAM_INFO",
            topics = {
                    KafkaConstants.TOPIC_TMS_TLK_SYSTEM_EXAM_INFO
            }, groupId = "${spring.kafka.consumer.group-id}-tenant-2-dispatch")
    public void ackTmsExamListener_TOPIC_TMS_TLK_SYSTEM_EXAM_INFO(List<ConsumerRecord<String, String>> records,
                                                           Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);
    }

    /**
     * 集团企业的数据权限问题
     * @param records
     * @param ack
     */
    @KafkaListener(
            id = "${spring.kafka.consumer.group-id}-tenant-2-dispatch-id-TOPIC_OBPM2_TENANT_DATA_PERMISSIONS",
            topics = {
                    KafkaConstants.TOPIC_OBPM2_TENANT_DATA_PERMISSIONS
            }, groupId = "${spring.kafka.consumer.group-id}-tenant-2-dispatch")
    public void ackConglomerateInformationListener_TOPIC_OBPM2_TENANT_DATA_PERMISSIONS(
            List<ConsumerRecord<String, String>> records, Acknowledgment ack) {
        executeConsumeData(syncRpcWriterProvider, records, ack);
    }


    protected static Collection<String> extractOrgFromJson(List<ConsumerRecord<String, String>> records,JsonProvider jsonProvider) {
        if (CollectionUtils.isEmpty(records)) {
            return null;
        }

        Collection<String> contents =
                records.stream().map(ii -> {
                    JSONObject data =
                            jsonProvider.toObject(JSONObject.class, ii.value());
                    if (data == null) {
                        return null;
                    }
                    JSONObject beforeNode = data.getJSONObject("before");
                    JSONObject afterNode = data.getJSONObject("after");

                    JSONObject node = afterNode == null ? beforeNode : afterNode;
                    if (node == null) {
                        return null;
                    }

                    String superviseDepartIdFieldName = "supervise_depart_id";
                    String beforeSuperviseDepartId = null;
                    String afterSuperviseDepartId = null;
                    Optional<String> superviseDepartIdFieldOptional = node.keySet().stream().filter(ix -> ix.equalsIgnoreCase(superviseDepartIdFieldName))
                            .findFirst();
                    if (!superviseDepartIdFieldOptional.isPresent()) {
                        return null;
                    }

                    if (beforeNode != null) {
                        beforeSuperviseDepartId = beforeNode.getString(superviseDepartIdFieldOptional.get());
                    }
                    if (afterNode != null) {
                        afterSuperviseDepartId = afterNode.getString(superviseDepartIdFieldOptional.get());
                    }

                    if (StringUtil.isEqual(beforeSuperviseDepartId, afterSuperviseDepartId)) {
                        return null;
                    }

                    /*
                    return ProprietorOrgWrapContent.ProprietorOrgContent.create(
                            node.getString("id"),
                            node.getString("name"),
                            node.getString("supervise_depart_id"),
                            node.getString("supervise_depart_name")
                    );
                     */

                    return node.getString("id");
                }).filter(ii -> ii != null).collect(Collectors.toList());

        if (CollectionUtils.isEmpty(contents)) {
            return null;
        }


        return contents;
    }
}
