package com.bcxin.tenant.open.backend.tasks.components;

import com.bcxin.tenant.open.backend.tasks.properties.RtcDeviceProperty;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.time.Instant;
import java.util.concurrent.CountDownLatch;

@Component
public class DeviceMqttCommandLineRunner implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(DeviceMqttCommandLineRunner.class);
    private final RtcDeviceProperty deviceProperty;
    private final MqttCallback mqttCallback;

    public DeviceMqttCommandLineRunner(RtcDeviceProperty deviceProperty, MqttCallback mqttCallback) {
        this.deviceProperty = deviceProperty;
        this.mqttCallback = mqttCallback;
    }

    @Override
    public void run(String... args) throws Exception {
        /**
         * https://docs.emqx.com/zh/emqx/latest/connect-emqx/java.html
         */
        logger.error("初始化mqtt的连接信息");

        IMqttClient mqttClient = null;

        try {
            MemoryPersistence persistence = new MemoryPersistence();
            mqttClient = new MqttClient(
                    this.deviceProperty.getMqttBroker(), String.format("emqx_%s", Instant.now().getEpochSecond()),
                    persistence
            );
            MqttConnectOptions options = new MqttConnectOptions();
            options.setUserName(deviceProperty.getMqttUserName());
            options.setPassword(deviceProperty.getMqttPassword().toCharArray());
            options.setCleanSession(true);

            mqttClient.setCallback(mqttCallback);

            mqttClient.connect(options);

            mqttClient.subscribe(deviceProperty.getMqttTopic());

            logger.error("mqtt初始化连接成功");

            CountDownLatch downLatch = new CountDownLatch(1);
            /**
             * 持续监听
             */
            downLatch.await();
        } catch (Exception ex){
            logger.error("初始化mqtt的连接信息失败", ex);
        }finally {
            if (mqttClient != null) {
                try {
                    mqttClient.disconnect();
                } catch (Exception ex) {
                    logger.error("disconnect mqttClient 异常", ex);
                }
                try {
                    mqttClient.close();
                } catch (Exception ex) {
                    logger.error("close mqttClient 异常", ex);
                }
            }
        }
    }
}
