package com.bcxin.backend.domain.syncs.dtos;

import com.bcxin.backend.domain.models.DomainSuperviseDTO;
import com.bcxin.backend.domain.models.SuperviseDTO;
import com.bcxin.runtime.domain.snapshoots.enums.SyncTargetType;
import com.bcxin.runtime.domain.syncs.dtos.DataSetDto;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

@Data
public class SyncDataSetDTO {
    private DataSetDto dataSetDto;
    private DomainSuperviseDTO domainSuperviseDTO;
    private SyncTargetType syncTargetType;
    private String note;

    public SyncDataSetDTO() {
    }

    public SyncDataSetDTO(SyncTargetType syncTargetType, DataSetDto dataSetDto, DomainSuperviseDTO domainSuperviseDTO) {
        this.syncTargetType = syncTargetType;
        this.dataSetDto = dataSetDto;
        this.domainSuperviseDTO = domainSuperviseDTO;
    }

    public static SyncDataSetDTO create(SyncTargetType syncTargetType, DataSetDto dataSetDto, DomainSuperviseDTO domainSuperviseDTO) {
        return new SyncDataSetDTO(syncTargetType, dataSetDto, domainSuperviseDTO);
    }

    @JsonIgnore
    public String getIdentityValue() {
        if (domainSuperviseDTO != null) {
            SuperviseDTO supervise = domainSuperviseDTO.getSupervise();
            if (supervise != null) {
                return String.format("Sync_%s_%s_%s", syncTargetType, dataSetDto.getTableName(), supervise.getRegionId());
            }
        }
        return String.format("type_%s_name_%s", syncTargetType.name(), dataSetDto.getTableName());
    }

    @JsonIgnore
    public String getKeyValue() {
        if (this.getDomainSuperviseDTO() == null) {
            return this.getSyncTargetType().name();
        }

        return this.getDomainSuperviseDTO().getDomainId();
    }

    public void markNote(String note) {
        this.setNote(note);
    }
}
