package com.bcxin.backend.domain.screening.factory;

import com.bcxin.backend.core.exceptions.SaasBadException;
import com.bcxin.backend.domain.screening.service.BackgrounpScreeningProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * <b> 背筛工厂 </b>
 * @author ZXF
 * @create 2022/09/22 0022 14:53
 * @version
 * @注意事项 </b>
 */
@Service
public class ScreeningFactory {

    @Autowired
    public Map<String, BackgrounpScreeningProvider> connectionMap = new ConcurrentHashMap<>();
    private @Value("${myapps.screeninng.serverKey}")String serverKey;

    public BackgrounpScreeningProvider getBSPByType(){
        String type = StringUtils.isEmpty(serverKey)?"bsp_common":serverKey;
        BackgrounpScreeningProvider service = this.connectionMap.get(type);
        if(service == null){
            throw new SaasBadException(String.format("BackgrounpScreeningType:%s dose not support", type));
        }
        return service;
    }
}
