package com.bcxin.backend.domain.repositories.dtos;

import com.bcxin.backend.domain.models.SuperviseDTO;
import lombok.Data;
import java.util.Collection;
import java.util.HashSet;

@Data
public class RegionSystemDomainGroupDTO {
    private Collection<String> domainIds;
    private final SuperviseDTO superviseDTO;
    public RegionSystemDomainGroupDTO(SuperviseDTO superviseDTO) {
        this.superviseDTO = superviseDTO;
        this.setDomainIds(new HashSet<>());
    }

    public void addDomainId(String domainId) {
        this.domainIds.add(domainId);
    }

    public boolean isExists(String domainId) {
        return this.getDomainIds().stream().anyMatch(ii -> ii.equalsIgnoreCase(domainId));
    }

    public boolean isRegionMatch(String regionId) {
        return this.getSuperviseDTO().getRegionId().equalsIgnoreCase(regionId);
    }

    public static RegionSystemDomainGroupDTO create(SuperviseDTO superviseDTO) {
        return new RegionSystemDomainGroupDTO(superviseDTO);
    }
}
