package com.bcxin.backend.domain.repositories;

import com.bcxin.backend.domain.models.SyncLogSourceModel;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;

public interface SyncLogSourceRepository extends JpaRepository<SyncLogSourceModel, Long> {

    @Query("select s from SyncLogSourceModel s where s.status=3 and s.category = 'cn.myapps.util.http.HttpRequestUtil' order by s.createdTime asc")
    Collection<SyncLogSourceModel> getReSyncData(PageRequest pageRequest);

    @Query("select s from SyncLogSourceModel s where s.status=5 and s.category = 'cn.myapps.util.http.HttpRequestUtil' order by s.createdTime asc")
    Collection<SyncLogSourceModel> getReSyncPartialDoneData(PageRequest pageRequest);

    @Modifying
    @Transactional
    @Query("update SyncLogSourceModel s set s.status=2 , s.createdTime=current_timestamp,s.message=?1 where s.id in (?2)")
    void updateSyncStatus();
}
